/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.networking.DestinationWeight;
import me.snowdrop.istio.api.model.v1.networking.DestinationWeightBuilder;
import me.snowdrop.istio.api.model.v1.networking.DestinationWeightFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.L4MatchAttributes;
import me.snowdrop.istio.api.model.v1.networking.L4MatchAttributesBuilder;
import me.snowdrop.istio.api.model.v1.networking.L4MatchAttributesFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.TCPRoute;
import me.snowdrop.istio.api.model.v1.networking.TCPRouteFluent;

public class TCPRouteFluentImpl<A extends TCPRouteFluent<A>>
extends BaseFluent<A>
implements TCPRouteFluent<A> {
    private List<L4MatchAttributesBuilder> match;
    private List<DestinationWeightBuilder> route;

    public TCPRouteFluentImpl() {
    }

    public TCPRouteFluentImpl(TCPRoute instance) {
        this.withMatch(instance.getMatch());
        this.withRoute(instance.getRoute());
    }

    @Override
    public A addToMatch(int index, L4MatchAttributes item) {
        if (this.match == null) {
            this.match = new ArrayList<L4MatchAttributesBuilder>();
        }
        L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.match.add(index >= 0 ? index : this.match.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatch(int index, L4MatchAttributes item) {
        if (this.match == null) {
            this.match = new ArrayList<L4MatchAttributesBuilder>();
        }
        L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.match.size()) {
            this.match.add(builder);
        } else {
            this.match.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatch(L4MatchAttributes ... items) {
        if (this.match == null) {
            this.match = new ArrayList<L4MatchAttributesBuilder>();
        }
        for (L4MatchAttributes item : items) {
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
            this._visitables.add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatch(Collection<L4MatchAttributes> items) {
        if (this.match == null) {
            this.match = new ArrayList<L4MatchAttributesBuilder>();
        }
        for (L4MatchAttributes item : items) {
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
            this._visitables.add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatch(L4MatchAttributes ... items) {
        for (L4MatchAttributes item : items) {
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
            this._visitables.remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatch(Collection<L4MatchAttributes> items) {
        for (L4MatchAttributes item : items) {
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
            this._visitables.remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<L4MatchAttributes> getMatch() {
        return TCPRouteFluentImpl.build(this.match);
    }

    @Override
    public List<L4MatchAttributes> buildMatch() {
        return TCPRouteFluentImpl.build(this.match);
    }

    @Override
    public L4MatchAttributes buildMatch(int index) {
        return this.match.get(index).build();
    }

    @Override
    public L4MatchAttributes buildFirstMatch() {
        return this.match.get(0).build();
    }

    @Override
    public L4MatchAttributes buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    @Override
    public L4MatchAttributes buildMatchingMatch(Predicate<L4MatchAttributesBuilder> predicate) {
        for (L4MatchAttributesBuilder item : this.match) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withMatch(List<L4MatchAttributes> match) {
        if (this.match != null) {
            this._visitables.removeAll(this.match);
        }
        if (match != null) {
            this.match = new ArrayList<L4MatchAttributesBuilder>();
            for (L4MatchAttributes item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)this;
    }

    @Override
    public A withMatch(L4MatchAttributes ... match) {
        this.match.clear();
        if (match != null) {
            for (L4MatchAttributes item : match) {
                this.addToMatch(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    @Override
    public TCPRouteFluent.MatchNested<A> addNewMatch() {
        return new MatchNestedImpl();
    }

    @Override
    public TCPRouteFluent.MatchNested<A> addNewMatchLike(L4MatchAttributes item) {
        return new MatchNestedImpl(-1, item);
    }

    @Override
    public TCPRouteFluent.MatchNested<A> setNewMatchLike(int index, L4MatchAttributes item) {
        return new MatchNestedImpl(index, item);
    }

    @Override
    public TCPRouteFluent.MatchNested<A> editMatch(int index) {
        if (this.match.size() <= index) {
            throw new RuntimeException("Can't edit match. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public TCPRouteFluent.MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException("Can't edit first match. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    @Override
    public TCPRouteFluent.MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last match. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public TCPRouteFluent.MatchNested<A> editMatchingMatch(Predicate<L4MatchAttributesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.apply((Object)this.match.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching match. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public A addToRoute(int index, DestinationWeight item) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.route.add(index >= 0 ? index : this.route.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRoute(int index, DestinationWeight item) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.route.size()) {
            this.route.add(builder);
        } else {
            this.route.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRoute(DestinationWeight ... items) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.add(builder);
            this.route.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoute(Collection<DestinationWeight> items) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.add(builder);
            this.route.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoute(DestinationWeight ... items) {
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.remove(builder);
            if (this.route == null) continue;
            this.route.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoute(Collection<DestinationWeight> items) {
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.remove(builder);
            if (this.route == null) continue;
            this.route.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DestinationWeight> getRoute() {
        return TCPRouteFluentImpl.build(this.route);
    }

    @Override
    public List<DestinationWeight> buildRoute() {
        return TCPRouteFluentImpl.build(this.route);
    }

    @Override
    public DestinationWeight buildRoute(int index) {
        return this.route.get(index).build();
    }

    @Override
    public DestinationWeight buildFirstRoute() {
        return this.route.get(0).build();
    }

    @Override
    public DestinationWeight buildLastRoute() {
        return this.route.get(this.route.size() - 1).build();
    }

    @Override
    public DestinationWeight buildMatchingRoute(Predicate<DestinationWeightBuilder> predicate) {
        for (DestinationWeightBuilder item : this.route) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRoute(List<DestinationWeight> route) {
        if (this.route != null) {
            this._visitables.removeAll(this.route);
        }
        if (route != null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
            for (DestinationWeight item : route) {
                this.addToRoute(item);
            }
        } else {
            this.route = null;
        }
        return (A)this;
    }

    @Override
    public A withRoute(DestinationWeight ... route) {
        this.route.clear();
        if (route != null) {
            for (DestinationWeight item : route) {
                this.addToRoute(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoute() {
        return this.route != null && !this.route.isEmpty();
    }

    @Override
    public TCPRouteFluent.RouteNested<A> addNewRoute() {
        return new RouteNestedImpl();
    }

    @Override
    public TCPRouteFluent.RouteNested<A> addNewRouteLike(DestinationWeight item) {
        return new RouteNestedImpl(-1, item);
    }

    @Override
    public TCPRouteFluent.RouteNested<A> setNewRouteLike(int index, DestinationWeight item) {
        return new RouteNestedImpl(index, item);
    }

    @Override
    public TCPRouteFluent.RouteNested<A> editRoute(int index) {
        if (this.route.size() <= index) {
            throw new RuntimeException("Can't edit route. Index exceeds size.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public TCPRouteFluent.RouteNested<A> editFirstRoute() {
        if (this.route.size() == 0) {
            throw new RuntimeException("Can't edit first route. The list is empty.");
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    @Override
    public TCPRouteFluent.RouteNested<A> editLastRoute() {
        int index = this.route.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last route. The list is empty.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public TCPRouteFluent.RouteNested<A> editMatchingRoute(Predicate<DestinationWeightBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.route.size(); ++i) {
            if (!predicate.apply((Object)this.route.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching route. No match found.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCPRouteFluentImpl that = (TCPRouteFluentImpl)o;
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        return !(this.route != null ? !this.route.equals(that.route) : that.route != null);
    }

    public class RouteNestedImpl<N>
    extends DestinationWeightFluentImpl<TCPRouteFluent.RouteNested<N>>
    implements TCPRouteFluent.RouteNested<N>,
    Nested<N> {
        private final DestinationWeightBuilder builder;
        private final int index;

        RouteNestedImpl(int index, DestinationWeight item) {
            this.index = index;
            this.builder = new DestinationWeightBuilder(this, item);
        }

        RouteNestedImpl() {
            this.index = -1;
            this.builder = new DestinationWeightBuilder(this);
        }

        @Override
        public N and() {
            return (N)TCPRouteFluentImpl.this.setToRoute(this.index, this.builder.build());
        }

        @Override
        public N endRoute() {
            return this.and();
        }
    }

    public class MatchNestedImpl<N>
    extends L4MatchAttributesFluentImpl<TCPRouteFluent.MatchNested<N>>
    implements TCPRouteFluent.MatchNested<N>,
    Nested<N> {
        private final L4MatchAttributesBuilder builder;
        private final int index;

        MatchNestedImpl(int index, L4MatchAttributes item) {
            this.index = index;
            this.builder = new L4MatchAttributesBuilder(this, item);
        }

        MatchNestedImpl() {
            this.index = -1;
            this.builder = new L4MatchAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)TCPRouteFluentImpl.this.setToMatch(this.index, this.builder.build());
        }

        @Override
        public N endMatch() {
            return this.and();
        }
    }
}

