/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.snowdrop.istio.api.model.Duration;
import me.snowdrop.istio.api.model.DurationBuilder;
import me.snowdrop.istio.api.model.DurationFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.CorsPolicy;
import me.snowdrop.istio.api.model.v1.networking.CorsPolicyBuilder;
import me.snowdrop.istio.api.model.v1.networking.CorsPolicyFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.Destination;
import me.snowdrop.istio.api.model.v1.networking.DestinationBuilder;
import me.snowdrop.istio.api.model.v1.networking.DestinationFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.DestinationWeight;
import me.snowdrop.istio.api.model.v1.networking.DestinationWeightBuilder;
import me.snowdrop.istio.api.model.v1.networking.DestinationWeightFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.HTTPFaultInjection;
import me.snowdrop.istio.api.model.v1.networking.HTTPFaultInjectionBuilder;
import me.snowdrop.istio.api.model.v1.networking.HTTPFaultInjectionFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.HTTPMatchRequest;
import me.snowdrop.istio.api.model.v1.networking.HTTPMatchRequestBuilder;
import me.snowdrop.istio.api.model.v1.networking.HTTPMatchRequestFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.HTTPRedirect;
import me.snowdrop.istio.api.model.v1.networking.HTTPRedirectBuilder;
import me.snowdrop.istio.api.model.v1.networking.HTTPRedirectFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.HTTPRetry;
import me.snowdrop.istio.api.model.v1.networking.HTTPRetryBuilder;
import me.snowdrop.istio.api.model.v1.networking.HTTPRetryFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.HTTPRewrite;
import me.snowdrop.istio.api.model.v1.networking.HTTPRewriteBuilder;
import me.snowdrop.istio.api.model.v1.networking.HTTPRewriteFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.HTTPRoute;
import me.snowdrop.istio.api.model.v1.networking.HTTPRouteFluent;

public class HTTPRouteFluentImpl<A extends HTTPRouteFluent<A>>
extends BaseFluent<A>
implements HTTPRouteFluent<A> {
    private Map<String, String> appendHeaders;
    private CorsPolicyBuilder corsPolicy;
    private HTTPFaultInjectionBuilder fault;
    private List<HTTPMatchRequestBuilder> match;
    private DestinationBuilder mirror;
    private HTTPRedirectBuilder redirect;
    private HTTPRetryBuilder retries;
    private HTTPRewriteBuilder rewrite;
    private List<DestinationWeightBuilder> route;
    private DurationBuilder timeout;
    private Boolean websocketUpgrade;

    public HTTPRouteFluentImpl() {
    }

    public HTTPRouteFluentImpl(HTTPRoute instance) {
        this.withAppendHeaders(instance.getAppendHeaders());
        this.withCorsPolicy(instance.getCorsPolicy());
        this.withFault(instance.getFault());
        this.withMatch(instance.getMatch());
        this.withMirror(instance.getMirror());
        this.withRedirect(instance.getRedirect());
        this.withRetries(instance.getRetries());
        this.withRewrite(instance.getRewrite());
        this.withRoute(instance.getRoute());
        this.withTimeout(instance.getTimeout());
        this.withWebsocketUpgrade(instance.getWebsocketUpgrade());
    }

    @Override
    public A addToAppendHeaders(String key, String value) {
        if (this.appendHeaders == null && key != null && value != null) {
            this.appendHeaders = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.appendHeaders.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAppendHeaders(Map<String, String> map) {
        if (this.appendHeaders == null && map != null) {
            this.appendHeaders = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.appendHeaders.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAppendHeaders(String key) {
        if (this.appendHeaders == null) {
            return (A)this;
        }
        if (key != null && this.appendHeaders != null) {
            this.appendHeaders.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAppendHeaders(Map<String, String> map) {
        if (this.appendHeaders == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.appendHeaders == null) continue;
                this.appendHeaders.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAppendHeaders() {
        return this.appendHeaders;
    }

    @Override
    public A withAppendHeaders(Map<String, String> appendHeaders) {
        this.appendHeaders = appendHeaders == null ? null : new LinkedHashMap<String, String>(appendHeaders);
        return (A)this;
    }

    @Override
    public Boolean hasAppendHeaders() {
        return this.appendHeaders != null;
    }

    @Override
    @Deprecated
    public CorsPolicy getCorsPolicy() {
        return this.corsPolicy != null ? this.corsPolicy.build() : null;
    }

    @Override
    public CorsPolicy buildCorsPolicy() {
        return this.corsPolicy != null ? this.corsPolicy.build() : null;
    }

    @Override
    public A withCorsPolicy(CorsPolicy corsPolicy) {
        this._visitables.remove(this.corsPolicy);
        if (corsPolicy != null) {
            this.corsPolicy = new CorsPolicyBuilder(corsPolicy);
            this._visitables.add(this.corsPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCorsPolicy() {
        return this.corsPolicy != null;
    }

    @Override
    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicy() {
        return new CorsPolicyNestedImpl();
    }

    @Override
    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicyLike(CorsPolicy item) {
        return new CorsPolicyNestedImpl(item);
    }

    @Override
    public HTTPRouteFluent.CorsPolicyNested<A> editCorsPolicy() {
        return this.withNewCorsPolicyLike(this.getCorsPolicy());
    }

    @Override
    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicy() {
        return this.withNewCorsPolicyLike(this.getCorsPolicy() != null ? this.getCorsPolicy() : new CorsPolicyBuilder().build());
    }

    @Override
    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicyLike(CorsPolicy item) {
        return this.withNewCorsPolicyLike(this.getCorsPolicy() != null ? this.getCorsPolicy() : item);
    }

    @Override
    @Deprecated
    public HTTPFaultInjection getFault() {
        return this.fault != null ? this.fault.build() : null;
    }

    @Override
    public HTTPFaultInjection buildFault() {
        return this.fault != null ? this.fault.build() : null;
    }

    @Override
    public A withFault(HTTPFaultInjection fault) {
        this._visitables.remove(this.fault);
        if (fault != null) {
            this.fault = new HTTPFaultInjectionBuilder(fault);
            this._visitables.add(this.fault);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFault() {
        return this.fault != null;
    }

    @Override
    public HTTPRouteFluent.FaultNested<A> withNewFault() {
        return new FaultNestedImpl();
    }

    @Override
    public HTTPRouteFluent.FaultNested<A> withNewFaultLike(HTTPFaultInjection item) {
        return new FaultNestedImpl(item);
    }

    @Override
    public HTTPRouteFluent.FaultNested<A> editFault() {
        return this.withNewFaultLike(this.getFault());
    }

    @Override
    public HTTPRouteFluent.FaultNested<A> editOrNewFault() {
        return this.withNewFaultLike(this.getFault() != null ? this.getFault() : new HTTPFaultInjectionBuilder().build());
    }

    @Override
    public HTTPRouteFluent.FaultNested<A> editOrNewFaultLike(HTTPFaultInjection item) {
        return this.withNewFaultLike(this.getFault() != null ? this.getFault() : item);
    }

    @Override
    public A addToMatch(int index, HTTPMatchRequest item) {
        if (this.match == null) {
            this.match = new ArrayList<HTTPMatchRequestBuilder>();
        }
        HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.match.add(index >= 0 ? index : this.match.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatch(int index, HTTPMatchRequest item) {
        if (this.match == null) {
            this.match = new ArrayList<HTTPMatchRequestBuilder>();
        }
        HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.match.size()) {
            this.match.add(builder);
        } else {
            this.match.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatch(HTTPMatchRequest ... items) {
        if (this.match == null) {
            this.match = new ArrayList<HTTPMatchRequestBuilder>();
        }
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatch(Collection<HTTPMatchRequest> items) {
        if (this.match == null) {
            this.match = new ArrayList<HTTPMatchRequestBuilder>();
        }
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatch(HTTPMatchRequest ... items) {
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatch(Collection<HTTPMatchRequest> items) {
        for (HTTPMatchRequest item : items) {
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            this._visitables.remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPMatchRequest> getMatch() {
        return HTTPRouteFluentImpl.build(this.match);
    }

    @Override
    public List<HTTPMatchRequest> buildMatch() {
        return HTTPRouteFluentImpl.build(this.match);
    }

    @Override
    public HTTPMatchRequest buildMatch(int index) {
        return this.match.get(index).build();
    }

    @Override
    public HTTPMatchRequest buildFirstMatch() {
        return this.match.get(0).build();
    }

    @Override
    public HTTPMatchRequest buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    @Override
    public HTTPMatchRequest buildMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
        for (HTTPMatchRequestBuilder item : this.match) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withMatch(List<HTTPMatchRequest> match) {
        if (this.match != null) {
            this._visitables.removeAll(this.match);
        }
        if (match != null) {
            this.match = new ArrayList<HTTPMatchRequestBuilder>();
            for (HTTPMatchRequest item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)this;
    }

    @Override
    public A withMatch(HTTPMatchRequest ... match) {
        this.match.clear();
        if (match != null) {
            for (HTTPMatchRequest item : match) {
                this.addToMatch(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    @Override
    public HTTPRouteFluent.MatchNested<A> addNewMatch() {
        return new MatchNestedImpl();
    }

    @Override
    public HTTPRouteFluent.MatchNested<A> addNewMatchLike(HTTPMatchRequest item) {
        return new MatchNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteFluent.MatchNested<A> setNewMatchLike(int index, HTTPMatchRequest item) {
        return new MatchNestedImpl(index, item);
    }

    @Override
    public HTTPRouteFluent.MatchNested<A> editMatch(int index) {
        if (this.match.size() <= index) {
            throw new RuntimeException("Can't edit match. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public HTTPRouteFluent.MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException("Can't edit first match. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    @Override
    public HTTPRouteFluent.MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last match. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public HTTPRouteFluent.MatchNested<A> editMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.apply((Object)this.match.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching match. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    @Deprecated
    public Destination getMirror() {
        return this.mirror != null ? this.mirror.build() : null;
    }

    @Override
    public Destination buildMirror() {
        return this.mirror != null ? this.mirror.build() : null;
    }

    @Override
    public A withMirror(Destination mirror) {
        this._visitables.remove(this.mirror);
        if (mirror != null) {
            this.mirror = new DestinationBuilder(mirror);
            this._visitables.add(this.mirror);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMirror() {
        return this.mirror != null;
    }

    @Override
    public HTTPRouteFluent.MirrorNested<A> withNewMirror() {
        return new MirrorNestedImpl();
    }

    @Override
    public HTTPRouteFluent.MirrorNested<A> withNewMirrorLike(Destination item) {
        return new MirrorNestedImpl(item);
    }

    @Override
    public HTTPRouteFluent.MirrorNested<A> editMirror() {
        return this.withNewMirrorLike(this.getMirror());
    }

    @Override
    public HTTPRouteFluent.MirrorNested<A> editOrNewMirror() {
        return this.withNewMirrorLike(this.getMirror() != null ? this.getMirror() : new DestinationBuilder().build());
    }

    @Override
    public HTTPRouteFluent.MirrorNested<A> editOrNewMirrorLike(Destination item) {
        return this.withNewMirrorLike(this.getMirror() != null ? this.getMirror() : item);
    }

    @Override
    @Deprecated
    public HTTPRedirect getRedirect() {
        return this.redirect != null ? this.redirect.build() : null;
    }

    @Override
    public HTTPRedirect buildRedirect() {
        return this.redirect != null ? this.redirect.build() : null;
    }

    @Override
    public A withRedirect(HTTPRedirect redirect) {
        this._visitables.remove(this.redirect);
        if (redirect != null) {
            this.redirect = new HTTPRedirectBuilder(redirect);
            this._visitables.add(this.redirect);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRedirect() {
        return this.redirect != null;
    }

    @Override
    public A withNewRedirect(String authority, String uri) {
        return this.withRedirect(new HTTPRedirect(authority, uri));
    }

    @Override
    public HTTPRouteFluent.RedirectNested<A> withNewRedirect() {
        return new RedirectNestedImpl();
    }

    @Override
    public HTTPRouteFluent.RedirectNested<A> withNewRedirectLike(HTTPRedirect item) {
        return new RedirectNestedImpl(item);
    }

    @Override
    public HTTPRouteFluent.RedirectNested<A> editRedirect() {
        return this.withNewRedirectLike(this.getRedirect());
    }

    @Override
    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirect() {
        return this.withNewRedirectLike(this.getRedirect() != null ? this.getRedirect() : new HTTPRedirectBuilder().build());
    }

    @Override
    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirectLike(HTTPRedirect item) {
        return this.withNewRedirectLike(this.getRedirect() != null ? this.getRedirect() : item);
    }

    @Override
    @Deprecated
    public HTTPRetry getRetries() {
        return this.retries != null ? this.retries.build() : null;
    }

    @Override
    public HTTPRetry buildRetries() {
        return this.retries != null ? this.retries.build() : null;
    }

    @Override
    public A withRetries(HTTPRetry retries) {
        this._visitables.remove(this.retries);
        if (retries != null) {
            this.retries = new HTTPRetryBuilder(retries);
            this._visitables.add(this.retries);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRetries() {
        return this.retries != null;
    }

    @Override
    public HTTPRouteFluent.RetriesNested<A> withNewRetries() {
        return new RetriesNestedImpl();
    }

    @Override
    public HTTPRouteFluent.RetriesNested<A> withNewRetriesLike(HTTPRetry item) {
        return new RetriesNestedImpl(item);
    }

    @Override
    public HTTPRouteFluent.RetriesNested<A> editRetries() {
        return this.withNewRetriesLike(this.getRetries());
    }

    @Override
    public HTTPRouteFluent.RetriesNested<A> editOrNewRetries() {
        return this.withNewRetriesLike(this.getRetries() != null ? this.getRetries() : new HTTPRetryBuilder().build());
    }

    @Override
    public HTTPRouteFluent.RetriesNested<A> editOrNewRetriesLike(HTTPRetry item) {
        return this.withNewRetriesLike(this.getRetries() != null ? this.getRetries() : item);
    }

    @Override
    @Deprecated
    public HTTPRewrite getRewrite() {
        return this.rewrite != null ? this.rewrite.build() : null;
    }

    @Override
    public HTTPRewrite buildRewrite() {
        return this.rewrite != null ? this.rewrite.build() : null;
    }

    @Override
    public A withRewrite(HTTPRewrite rewrite) {
        this._visitables.remove(this.rewrite);
        if (rewrite != null) {
            this.rewrite = new HTTPRewriteBuilder(rewrite);
            this._visitables.add(this.rewrite);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRewrite() {
        return this.rewrite != null;
    }

    @Override
    public A withNewRewrite(String authority, String uri) {
        return this.withRewrite(new HTTPRewrite(authority, uri));
    }

    @Override
    public HTTPRouteFluent.RewriteNested<A> withNewRewrite() {
        return new RewriteNestedImpl();
    }

    @Override
    public HTTPRouteFluent.RewriteNested<A> withNewRewriteLike(HTTPRewrite item) {
        return new RewriteNestedImpl(item);
    }

    @Override
    public HTTPRouteFluent.RewriteNested<A> editRewrite() {
        return this.withNewRewriteLike(this.getRewrite());
    }

    @Override
    public HTTPRouteFluent.RewriteNested<A> editOrNewRewrite() {
        return this.withNewRewriteLike(this.getRewrite() != null ? this.getRewrite() : new HTTPRewriteBuilder().build());
    }

    @Override
    public HTTPRouteFluent.RewriteNested<A> editOrNewRewriteLike(HTTPRewrite item) {
        return this.withNewRewriteLike(this.getRewrite() != null ? this.getRewrite() : item);
    }

    @Override
    public A addToRoute(int index, DestinationWeight item) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.route.add(index >= 0 ? index : this.route.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRoute(int index, DestinationWeight item) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.route.size()) {
            this.route.add(builder);
        } else {
            this.route.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRoute(DestinationWeight ... items) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.add(builder);
            this.route.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoute(Collection<DestinationWeight> items) {
        if (this.route == null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
        }
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.add(builder);
            this.route.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoute(DestinationWeight ... items) {
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.remove(builder);
            if (this.route == null) continue;
            this.route.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoute(Collection<DestinationWeight> items) {
        for (DestinationWeight item : items) {
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            this._visitables.remove(builder);
            if (this.route == null) continue;
            this.route.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DestinationWeight> getRoute() {
        return HTTPRouteFluentImpl.build(this.route);
    }

    @Override
    public List<DestinationWeight> buildRoute() {
        return HTTPRouteFluentImpl.build(this.route);
    }

    @Override
    public DestinationWeight buildRoute(int index) {
        return this.route.get(index).build();
    }

    @Override
    public DestinationWeight buildFirstRoute() {
        return this.route.get(0).build();
    }

    @Override
    public DestinationWeight buildLastRoute() {
        return this.route.get(this.route.size() - 1).build();
    }

    @Override
    public DestinationWeight buildMatchingRoute(Predicate<DestinationWeightBuilder> predicate) {
        for (DestinationWeightBuilder item : this.route) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRoute(List<DestinationWeight> route) {
        if (this.route != null) {
            this._visitables.removeAll(this.route);
        }
        if (route != null) {
            this.route = new ArrayList<DestinationWeightBuilder>();
            for (DestinationWeight item : route) {
                this.addToRoute(item);
            }
        } else {
            this.route = null;
        }
        return (A)this;
    }

    @Override
    public A withRoute(DestinationWeight ... route) {
        this.route.clear();
        if (route != null) {
            for (DestinationWeight item : route) {
                this.addToRoute(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoute() {
        return this.route != null && !this.route.isEmpty();
    }

    @Override
    public HTTPRouteFluent.RouteNested<A> addNewRoute() {
        return new RouteNestedImpl();
    }

    @Override
    public HTTPRouteFluent.RouteNested<A> addNewRouteLike(DestinationWeight item) {
        return new RouteNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteFluent.RouteNested<A> setNewRouteLike(int index, DestinationWeight item) {
        return new RouteNestedImpl(index, item);
    }

    @Override
    public HTTPRouteFluent.RouteNested<A> editRoute(int index) {
        if (this.route.size() <= index) {
            throw new RuntimeException("Can't edit route. Index exceeds size.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public HTTPRouteFluent.RouteNested<A> editFirstRoute() {
        if (this.route.size() == 0) {
            throw new RuntimeException("Can't edit first route. The list is empty.");
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    @Override
    public HTTPRouteFluent.RouteNested<A> editLastRoute() {
        int index = this.route.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last route. The list is empty.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public HTTPRouteFluent.RouteNested<A> editMatchingRoute(Predicate<DestinationWeightBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.route.size(); ++i) {
            if (!predicate.apply((Object)this.route.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching route. No match found.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    @Deprecated
    public Duration getTimeout() {
        return this.timeout != null ? this.timeout.build() : null;
    }

    @Override
    public Duration buildTimeout() {
        return this.timeout != null ? this.timeout.build() : null;
    }

    @Override
    public A withTimeout(Duration timeout) {
        this._visitables.remove(this.timeout);
        if (timeout != null) {
            this.timeout = new DurationBuilder(timeout);
            this._visitables.add(this.timeout);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    @Override
    public A withNewTimeout(Integer nanos, Long seconds) {
        return this.withTimeout(new Duration(nanos, seconds));
    }

    @Override
    public HTTPRouteFluent.TimeoutNested<A> withNewTimeout() {
        return new TimeoutNestedImpl();
    }

    @Override
    public HTTPRouteFluent.TimeoutNested<A> withNewTimeoutLike(Duration item) {
        return new TimeoutNestedImpl(item);
    }

    @Override
    public HTTPRouteFluent.TimeoutNested<A> editTimeout() {
        return this.withNewTimeoutLike(this.getTimeout());
    }

    @Override
    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeout() {
        return this.withNewTimeoutLike(this.getTimeout() != null ? this.getTimeout() : new DurationBuilder().build());
    }

    @Override
    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeoutLike(Duration item) {
        return this.withNewTimeoutLike(this.getTimeout() != null ? this.getTimeout() : item);
    }

    @Override
    public Boolean isWebsocketUpgrade() {
        return this.websocketUpgrade;
    }

    @Override
    public A withWebsocketUpgrade(Boolean websocketUpgrade) {
        this.websocketUpgrade = websocketUpgrade;
        return (A)this;
    }

    @Override
    public Boolean hasWebsocketUpgrade() {
        return this.websocketUpgrade != null;
    }

    @Override
    public A withNewWebsocketUpgrade(boolean arg1) {
        return this.withWebsocketUpgrade(new Boolean(arg1));
    }

    @Override
    public A withNewWebsocketUpgrade(String arg1) {
        return this.withWebsocketUpgrade(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteFluentImpl that = (HTTPRouteFluentImpl)o;
        if (this.appendHeaders != null ? !this.appendHeaders.equals(that.appendHeaders) : that.appendHeaders != null) {
            return false;
        }
        if (this.corsPolicy != null ? !this.corsPolicy.equals(that.corsPolicy) : that.corsPolicy != null) {
            return false;
        }
        if (this.fault != null ? !this.fault.equals(that.fault) : that.fault != null) {
            return false;
        }
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.mirror != null ? !this.mirror.equals(that.mirror) : that.mirror != null) {
            return false;
        }
        if (this.redirect != null ? !this.redirect.equals(that.redirect) : that.redirect != null) {
            return false;
        }
        if (this.retries != null ? !this.retries.equals(that.retries) : that.retries != null) {
            return false;
        }
        if (this.rewrite != null ? !this.rewrite.equals(that.rewrite) : that.rewrite != null) {
            return false;
        }
        if (this.route != null ? !this.route.equals(that.route) : that.route != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) {
            return false;
        }
        return !(this.websocketUpgrade != null ? !this.websocketUpgrade.equals(that.websocketUpgrade) : that.websocketUpgrade != null);
    }

    public class TimeoutNestedImpl<N>
    extends DurationFluentImpl<HTTPRouteFluent.TimeoutNested<N>>
    implements HTTPRouteFluent.TimeoutNested<N>,
    Nested<N> {
        private final DurationBuilder builder;

        TimeoutNestedImpl(Duration item) {
            this.builder = new DurationBuilder(this, item);
        }

        TimeoutNestedImpl() {
            this.builder = new DurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.withTimeout(this.builder.build());
        }

        @Override
        public N endTimeout() {
            return this.and();
        }
    }

    public class RouteNestedImpl<N>
    extends DestinationWeightFluentImpl<HTTPRouteFluent.RouteNested<N>>
    implements HTTPRouteFluent.RouteNested<N>,
    Nested<N> {
        private final DestinationWeightBuilder builder;
        private final int index;

        RouteNestedImpl(int index, DestinationWeight item) {
            this.index = index;
            this.builder = new DestinationWeightBuilder(this, item);
        }

        RouteNestedImpl() {
            this.index = -1;
            this.builder = new DestinationWeightBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.setToRoute(this.index, this.builder.build());
        }

        @Override
        public N endRoute() {
            return this.and();
        }
    }

    public class RewriteNestedImpl<N>
    extends HTTPRewriteFluentImpl<HTTPRouteFluent.RewriteNested<N>>
    implements HTTPRouteFluent.RewriteNested<N>,
    Nested<N> {
        private final HTTPRewriteBuilder builder;

        RewriteNestedImpl(HTTPRewrite item) {
            this.builder = new HTTPRewriteBuilder(this, item);
        }

        RewriteNestedImpl() {
            this.builder = new HTTPRewriteBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.withRewrite(this.builder.build());
        }

        @Override
        public N endRewrite() {
            return this.and();
        }
    }

    public class RetriesNestedImpl<N>
    extends HTTPRetryFluentImpl<HTTPRouteFluent.RetriesNested<N>>
    implements HTTPRouteFluent.RetriesNested<N>,
    Nested<N> {
        private final HTTPRetryBuilder builder;

        RetriesNestedImpl(HTTPRetry item) {
            this.builder = new HTTPRetryBuilder(this, item);
        }

        RetriesNestedImpl() {
            this.builder = new HTTPRetryBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.withRetries(this.builder.build());
        }

        @Override
        public N endRetries() {
            return this.and();
        }
    }

    public class RedirectNestedImpl<N>
    extends HTTPRedirectFluentImpl<HTTPRouteFluent.RedirectNested<N>>
    implements HTTPRouteFluent.RedirectNested<N>,
    Nested<N> {
        private final HTTPRedirectBuilder builder;

        RedirectNestedImpl(HTTPRedirect item) {
            this.builder = new HTTPRedirectBuilder(this, item);
        }

        RedirectNestedImpl() {
            this.builder = new HTTPRedirectBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.withRedirect(this.builder.build());
        }

        @Override
        public N endRedirect() {
            return this.and();
        }
    }

    public class MirrorNestedImpl<N>
    extends DestinationFluentImpl<HTTPRouteFluent.MirrorNested<N>>
    implements HTTPRouteFluent.MirrorNested<N>,
    Nested<N> {
        private final DestinationBuilder builder;

        MirrorNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        MirrorNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.withMirror(this.builder.build());
        }

        @Override
        public N endMirror() {
            return this.and();
        }
    }

    public class MatchNestedImpl<N>
    extends HTTPMatchRequestFluentImpl<HTTPRouteFluent.MatchNested<N>>
    implements HTTPRouteFluent.MatchNested<N>,
    Nested<N> {
        private final HTTPMatchRequestBuilder builder;
        private final int index;

        MatchNestedImpl(int index, HTTPMatchRequest item) {
            this.index = index;
            this.builder = new HTTPMatchRequestBuilder(this, item);
        }

        MatchNestedImpl() {
            this.index = -1;
            this.builder = new HTTPMatchRequestBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.setToMatch(this.index, this.builder.build());
        }

        @Override
        public N endMatch() {
            return this.and();
        }
    }

    public class FaultNestedImpl<N>
    extends HTTPFaultInjectionFluentImpl<HTTPRouteFluent.FaultNested<N>>
    implements HTTPRouteFluent.FaultNested<N>,
    Nested<N> {
        private final HTTPFaultInjectionBuilder builder;

        FaultNestedImpl(HTTPFaultInjection item) {
            this.builder = new HTTPFaultInjectionBuilder(this, item);
        }

        FaultNestedImpl() {
            this.builder = new HTTPFaultInjectionBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.withFault(this.builder.build());
        }

        @Override
        public N endFault() {
            return this.and();
        }
    }

    public class CorsPolicyNestedImpl<N>
    extends CorsPolicyFluentImpl<HTTPRouteFluent.CorsPolicyNested<N>>
    implements HTTPRouteFluent.CorsPolicyNested<N>,
    Nested<N> {
        private final CorsPolicyBuilder builder;

        CorsPolicyNestedImpl(CorsPolicy item) {
            this.builder = new CorsPolicyBuilder(this, item);
        }

        CorsPolicyNestedImpl() {
            this.builder = new CorsPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteFluentImpl.this.withCorsPolicy(this.builder.build());
        }

        @Override
        public N endCorsPolicy() {
            return this.and();
        }
    }
}

