/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import me.snowdrop.istio.api.model.v1.networking.Endpoint;
import me.snowdrop.istio.api.model.v1.networking.EndpointFluent;

public class EndpointFluentImpl<A extends EndpointFluent<A>>
extends BaseFluent<A>
implements EndpointFluent<A> {
    private String address;
    private Map<String, String> labels;
    private Map<String, Integer> ports;

    public EndpointFluentImpl() {
    }

    public EndpointFluentImpl(Endpoint instance) {
        this.withAddress(instance.getAddress());
        this.withLabels(instance.getLabels());
        this.withPorts(instance.getPorts());
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public A withAddress(String address) {
        this.address = address;
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public A addToPorts(String key, Integer value) {
        if (this.ports == null && key != null && value != null) {
            this.ports = new LinkedHashMap<String, Integer>();
        }
        if (key != null && value != null) {
            this.ports.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Map<String, Integer> map) {
        if (this.ports == null && map != null) {
            this.ports = new LinkedHashMap<String, Integer>();
        }
        if (map != null) {
            this.ports.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(String key) {
        if (this.ports == null) {
            return (A)this;
        }
        if (key != null && this.ports != null) {
            this.ports.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Map<String, Integer> map) {
        if (this.ports == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.ports == null) continue;
                this.ports.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    @Override
    public A withPorts(Map<String, Integer> ports) {
        this.ports = ports == null ? null : new LinkedHashMap<String, Integer>(ports);
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointFluentImpl that = (EndpointFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }
}

