/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.mixer.template;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import me.snowdrop.istio.api.model.TimeStamp;
import me.snowdrop.istio.api.model.TimeStampBuilder;
import me.snowdrop.istio.api.model.TimeStampFluentImpl;
import me.snowdrop.istio.api.model.v1.mixer.template.ApiKey;
import me.snowdrop.istio.api.model.v1.mixer.template.ApiKeyFluent;

public class ApiKeyFluentImpl<A extends ApiKeyFluent<A>>
extends BaseFluent<A>
implements ApiKeyFluent<A> {
    private String api;
    private String apiKey;
    private String apiOperation;
    private String apiVersion;
    private String name;
    private TimeStampBuilder timestamp;

    public ApiKeyFluentImpl() {
    }

    public ApiKeyFluentImpl(ApiKey instance) {
        this.withApi(instance.getApi());
        this.withApiKey(instance.getApiKey());
        this.withApiOperation(instance.getApiOperation());
        this.withApiVersion(instance.getApiVersion());
        this.withName(instance.getName());
        this.withTimestamp(instance.getTimestamp());
    }

    @Override
    public String getApi() {
        return this.api;
    }

    @Override
    public A withApi(String api) {
        this.api = api;
        return (A)this;
    }

    @Override
    public Boolean hasApi() {
        return this.api != null;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public A withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return (A)this;
    }

    @Override
    public Boolean hasApiKey() {
        return this.apiKey != null;
    }

    @Override
    public String getApiOperation() {
        return this.apiOperation;
    }

    @Override
    public A withApiOperation(String apiOperation) {
        this.apiOperation = apiOperation;
        return (A)this;
    }

    @Override
    public Boolean hasApiOperation() {
        return this.apiOperation != null;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public TimeStamp getTimestamp() {
        return this.timestamp != null ? this.timestamp.build() : null;
    }

    @Override
    public TimeStamp buildTimestamp() {
        return this.timestamp != null ? this.timestamp.build() : null;
    }

    @Override
    public A withTimestamp(TimeStamp timestamp) {
        this._visitables.remove(this.timestamp);
        if (timestamp != null) {
            this.timestamp = new TimeStampBuilder(timestamp);
            this._visitables.add(this.timestamp);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTimestamp() {
        return this.timestamp != null;
    }

    @Override
    public A withNewTimestamp(Integer nanos, Long seconds) {
        return this.withTimestamp(new TimeStamp(nanos, seconds));
    }

    @Override
    public ApiKeyFluent.TimestampNested<A> withNewTimestamp() {
        return new TimestampNestedImpl();
    }

    @Override
    public ApiKeyFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item) {
        return new TimestampNestedImpl(item);
    }

    @Override
    public ApiKeyFluent.TimestampNested<A> editTimestamp() {
        return this.withNewTimestampLike(this.getTimestamp());
    }

    @Override
    public ApiKeyFluent.TimestampNested<A> editOrNewTimestamp() {
        return this.withNewTimestampLike(this.getTimestamp() != null ? this.getTimestamp() : new TimeStampBuilder().build());
    }

    @Override
    public ApiKeyFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item) {
        return this.withNewTimestampLike(this.getTimestamp() != null ? this.getTimestamp() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApiKeyFluentImpl that = (ApiKeyFluentImpl)o;
        if (this.api != null ? !this.api.equals(that.api) : that.api != null) {
            return false;
        }
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.apiOperation != null ? !this.apiOperation.equals(that.apiOperation) : that.apiOperation != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null);
    }

    public class TimestampNestedImpl<N>
    extends TimeStampFluentImpl<ApiKeyFluent.TimestampNested<N>>
    implements ApiKeyFluent.TimestampNested<N>,
    Nested<N> {
        private final TimeStampBuilder builder;

        TimestampNestedImpl(TimeStamp item) {
            this.builder = new TimeStampBuilder(this, item);
        }

        TimestampNestedImpl() {
            this.builder = new TimeStampBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApiKeyFluentImpl.this.withTimestamp(this.builder.build());
        }

        @Override
        public N endTimestamp() {
            return this.and();
        }
    }
}

