/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.mesh;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.mesh.MeshConfig;
import me.snowdrop.istio.api.model.v1.mesh.MeshConfigFluent;
import me.snowdrop.istio.api.model.v1.mesh.MeshConfigFluentImpl;

public class MeshConfigBuilder
extends MeshConfigFluentImpl<MeshConfigBuilder>
implements VisitableBuilder<MeshConfig, MeshConfigBuilder> {
    MeshConfigFluent<?> fluent;
    Boolean validationEnabled;

    public MeshConfigBuilder() {
        this(true);
    }

    public MeshConfigBuilder(Boolean validationEnabled) {
        this(new MeshConfig(), validationEnabled);
    }

    public MeshConfigBuilder(MeshConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MeshConfigBuilder(MeshConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MeshConfig(), validationEnabled);
    }

    public MeshConfigBuilder(MeshConfigFluent<?> fluent, MeshConfig instance) {
        this(fluent, instance, true);
    }

    public MeshConfigBuilder(MeshConfigFluent<?> fluent, MeshConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAccessLogFile(instance.getAccessLogFile());
        fluent.withAuthPolicy(instance.getAuthPolicy());
        fluent.withConnectTimeout(instance.getConnectTimeout());
        fluent.withDefaultConfig(instance.getDefaultConfig());
        fluent.withDisablePolicyChecks(instance.getDisablePolicyChecks());
        fluent.withEnableTracing(instance.getEnableTracing());
        fluent.withIngressClass(instance.getIngressClass());
        fluent.withIngressControllerMode(instance.getIngressControllerMode());
        fluent.withIngressService(instance.getIngressService());
        fluent.withMixerAddress(instance.getMixerAddress());
        fluent.withMixerCheckServer(instance.getMixerCheckServer());
        fluent.withMixerReportServer(instance.getMixerReportServer());
        fluent.withMtlsExcludedServices(instance.getMtlsExcludedServices());
        fluent.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy());
        fluent.withProxyHttpPort(instance.getProxyHttpPort());
        fluent.withProxyListenPort(instance.getProxyListenPort());
        fluent.withRdsRefreshDelay(instance.getRdsRefreshDelay());
        this.validationEnabled = validationEnabled;
    }

    public MeshConfigBuilder(MeshConfig instance) {
        this(instance, (Boolean)true);
    }

    public MeshConfigBuilder(MeshConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAccessLogFile(instance.getAccessLogFile());
        this.withAuthPolicy(instance.getAuthPolicy());
        this.withConnectTimeout(instance.getConnectTimeout());
        this.withDefaultConfig(instance.getDefaultConfig());
        this.withDisablePolicyChecks(instance.getDisablePolicyChecks());
        this.withEnableTracing(instance.getEnableTracing());
        this.withIngressClass(instance.getIngressClass());
        this.withIngressControllerMode(instance.getIngressControllerMode());
        this.withIngressService(instance.getIngressService());
        this.withMixerAddress(instance.getMixerAddress());
        this.withMixerCheckServer(instance.getMixerCheckServer());
        this.withMixerReportServer(instance.getMixerReportServer());
        this.withMtlsExcludedServices(instance.getMtlsExcludedServices());
        this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy());
        this.withProxyHttpPort(instance.getProxyHttpPort());
        this.withProxyListenPort(instance.getProxyListenPort());
        this.withRdsRefreshDelay(instance.getRdsRefreshDelay());
        this.validationEnabled = validationEnabled;
    }

    public MeshConfig build() {
        MeshConfig buildable = new MeshConfig(this.fluent.getAccessLogFile(), this.fluent.getAuthPolicy(), this.fluent.getConnectTimeout(), this.fluent.getDefaultConfig(), this.fluent.isDisablePolicyChecks(), this.fluent.isEnableTracing(), this.fluent.getIngressClass(), this.fluent.getIngressControllerMode(), this.fluent.getIngressService(), this.fluent.getMixerAddress(), this.fluent.getMixerCheckServer(), this.fluent.getMixerReportServer(), this.fluent.getMtlsExcludedServices(), this.fluent.getOutboundTrafficPolicy(), this.fluent.getProxyHttpPort(), this.fluent.getProxyListenPort(), this.fluent.getRdsRefreshDelay());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MeshConfigBuilder that = (MeshConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

