/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class TimeStamp
implements Serializable {
    private Integer nanos;
    private Long seconds;
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTime();

    public TimeStamp() {
    }

    public TimeStamp(Integer nanos, Long seconds) {
        this.nanos = nanos;
        this.seconds = seconds;
    }

    public Integer getNanos() {
        return this.nanos;
    }

    public Long getSeconds() {
        return this.seconds;
    }

    public String toString() {
        return "TimeStamp(nanos=" + this.getNanos() + ", seconds=" + this.getSeconds() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeStamp)) {
            return false;
        }
        TimeStamp other = (TimeStamp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$nanos = this.getNanos();
        Integer other$nanos = other.getNanos();
        if (this$nanos == null ? other$nanos != null : !((Object)this$nanos).equals(other$nanos)) {
            return false;
        }
        Long this$seconds = this.getSeconds();
        Long other$seconds = other.getSeconds();
        return !(this$seconds == null ? other$seconds != null : !((Object)this$seconds).equals(other$seconds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeStamp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $nanos = this.getNanos();
        result = result * 59 + ($nanos == null ? 43 : ((Object)$nanos).hashCode());
        Long $seconds = this.getSeconds();
        result = result * 59 + ($seconds == null ? 43 : ((Object)$seconds).hashCode());
        return result;
    }

    public static class Serializer
    extends JsonSerializer<TimeStamp> {
        public void serialize(TimeStamp value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(FORMATTER.print((ReadableInstant)new DateTime(value.getSeconds() * 1000L)));
        }
    }

    public static class Deserializer
    extends JsonDeserializer<TimeStamp> {
        public TimeStamp deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            DateTime dateTime = FORMATTER.parseDateTime(node.asText());
            return new TimeStamp(0, dateTime.getMillis() / 1000L);
        }
    }
}

