/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import me.snowdrop.istio.api.model.Duration;
import me.snowdrop.istio.api.model.DurationFluent;
import me.snowdrop.istio.api.model.DurationFluentImpl;

public class DurationBuilder
extends DurationFluentImpl<DurationBuilder>
implements VisitableBuilder<Duration, DurationBuilder> {
    DurationFluent<?> fluent;
    Boolean validationEnabled;

    public DurationBuilder() {
        this(true);
    }

    public DurationBuilder(Boolean validationEnabled) {
        this(new Duration(), validationEnabled);
    }

    public DurationBuilder(DurationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DurationBuilder(DurationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Duration(), validationEnabled);
    }

    public DurationBuilder(DurationFluent<?> fluent, Duration instance) {
        this(fluent, instance, true);
    }

    public DurationBuilder(DurationFluent<?> fluent, Duration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNanos(instance.getNanos());
        fluent.withSeconds(instance.getSeconds());
        this.validationEnabled = validationEnabled;
    }

    public DurationBuilder(Duration instance) {
        this(instance, (Boolean)true);
    }

    public DurationBuilder(Duration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNanos(instance.getNanos());
        this.withSeconds(instance.getSeconds());
        this.validationEnabled = validationEnabled;
    }

    public Duration build() {
        Duration buildable = new Duration(this.fluent.getNanos(), this.fluent.getSeconds());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DurationBuilder that = (DurationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

