/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.v4_0.ListMeta;
import java.io.IOException;
import java.util.ArrayList;
import me.snowdrop.istio.api.model.IstioResource;
import me.snowdrop.istio.api.model.IstioResourceList;

public class IstioListDeserializer
extends JsonDeserializer<IstioResourceList> {
    private static final String KIND = "kind";

    public IstioResourceList deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)p.readValueAsTree();
        JsonNode kindNode = node.get(KIND);
        if (kindNode != null) {
            String kind = kindNode.textValue();
            String apiVersion = node.get("apiVersion").textValue();
            JsonNode metadataNode = node.get("metadata");
            ListMeta metadata = (ListMeta)p.getCodec().treeToValue((TreeNode)metadataNode, ListMeta.class);
            JsonNode itemsNode = node.get("items");
            ArrayList<IstioResource> items = new ArrayList<IstioResource>();
            for (JsonNode elementNode : itemsNode) {
                IstioResource resource = (IstioResource)p.getCodec().treeToValue((TreeNode)elementNode, IstioResource.class);
                items.add(resource);
            }
            return new IstioResourceList(apiVersion, items, kind, metadata);
        }
        throw new IllegalArgumentException("Cannot process resources without a 'kind' field");
    }
}

