/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMeta;
import java.io.IOException;
import me.snowdrop.istio.api.internal.IstioSpecRegistry;
import me.snowdrop.istio.api.model.IstioResource;
import me.snowdrop.istio.api.model.IstioSpec;

public class IstioDeserializer
extends JsonDeserializer<IstioResource> {
    private static final String KIND = "kind";

    public IstioResource deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)p.readValueAsTree();
        JsonNode kindNode = node.get(KIND);
        if (kindNode != null) {
            String kind = kindNode.textValue();
            Class<? extends IstioSpec> specType = IstioSpecRegistry.resolveIstioSpecForKind(kind);
            if (specType == null) {
                throw ctxt.mappingException(String.format("No resource type found for kind: %s", kind));
            }
            String apiVersion = node.get("apiVersion").textValue();
            JsonNode metadataNode = node.get("metadata");
            ObjectMeta metadata = (ObjectMeta)p.getCodec().treeToValue((TreeNode)metadataNode, ObjectMeta.class);
            JsonNode specNode = node.get("spec");
            IstioSpec spec = (IstioSpec)p.getCodec().treeToValue((TreeNode)specNode, specType);
            return new IstioResource(apiVersion, kind, metadata, spec);
        }
        throw new IllegalArgumentException("Cannot process resources without a 'kind' field");
    }
}

