/*
 * Decompiled with CFR 0.152.
 */
package me.sniggle.matemonkey4j.api.query;

import java.util.HashSet;
import java.util.Set;
import me.sniggle.matemonkey4j.api.model.DealerType;
import me.sniggle.matemonkey4j.api.query.Query;

public final class DealerQueryBuilder
implements Query {
    private BBox bbox = null;
    private final Set<DealerType> dealerTypes = new HashSet<DealerType>();
    private final Set<String> productIds = new HashSet<String>();

    private DealerQueryBuilder() {
    }

    public static DealerQueryBuilder create() {
        return new DealerQueryBuilder();
    }

    public DealerQueryBuilder bbox(double latitudeLeft, double longitudeBottom, double latitudeRight, double longitudeTop) {
        if (latitudeLeft > 90.0 || latitudeLeft < -90.0 || latitudeRight > 90.0 || latitudeRight < -90.0) {
            throw new IllegalArgumentException("Latitudes must be between -90.0 <= latitude <= 90.0, but was latitudeLeft: " + latitudeLeft + " and latitudeRight: " + latitudeRight);
        }
        if (longitudeBottom > 180.0 || longitudeBottom < -180.0 || longitudeTop > 180.0 || longitudeTop < -180.0) {
            throw new IllegalArgumentException("Longitudes must be between -180.0 <= longitude <= 180.0, but was longitudeTop: " + longitudeTop + " and longitudeBottom: " + longitudeBottom);
        }
        this.bbox = new BBox(latitudeLeft, latitudeRight, longitudeTop, longitudeBottom);
        return this;
    }

    public DealerQueryBuilder addDealerType(DealerType dealerType) {
        if (dealerType != null) {
            this.dealerTypes.add(dealerType);
        }
        return this;
    }

    public DealerQueryBuilder addProductId(String productId) {
        if (productId != null && !productId.trim().isEmpty()) {
            this.productIds.add(productId);
        }
        return this;
    }

    public Query build() {
        return this;
    }

    @Override
    public String toQuery() {
        StringBuilder builder;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.bbox != null) {
            stringBuilder.append(this.bbox.toQuery());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('&');
        }
        if (!this.dealerTypes.isEmpty()) {
            builder = new StringBuilder("type=");
            for (DealerType dealerType : this.dealerTypes) {
                builder.append(dealerType.type());
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
            stringBuilder.append((CharSequence)builder);
            stringBuilder.append('&');
        }
        if (!this.productIds.isEmpty()) {
            builder = new StringBuilder("product=");
            for (String productId : this.productIds) {
                builder.append(productId);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
            stringBuilder.append((CharSequence)builder);
            stringBuilder.append('&');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private class BBox
    implements Query {
        private final double latitudeLeft;
        private final double latitudeRight;
        private final double longitudeTop;
        private final double longitudeBottom;

        public BBox(double latitudeLeft, double latitudeRight, double longitudeTop, double longitudeBottom) {
            this.latitudeLeft = latitudeLeft;
            this.latitudeRight = latitudeRight;
            this.longitudeTop = longitudeTop;
            this.longitudeBottom = longitudeBottom;
        }

        @Override
        public String toQuery() {
            return "bbox=" + this.latitudeLeft + "," + this.longitudeBottom + "," + this.latitudeRight + "," + this.longitudeTop;
        }
    }
}

