/*
 * Decompiled with CFR 0.152.
 */
package me.sniggle.common.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.conn.util.PublicSuffixMatcher;

public class CertificateFingerprintHostnameVerifier
implements HostnameVerifier {
    private final Map<String, String> fingerprints = new HashMap<String, String>();
    private final PublicSuffixMatcher publicSuffixMatcher;

    public CertificateFingerprintHostnameVerifier(Map<String, String> fingerprints) {
        this(fingerprints, null);
    }

    public CertificateFingerprintHostnameVerifier(Map<String, String> fingerprints, PublicSuffixMatcher publicSuffixMatcher) {
        if (fingerprints != null) {
            for (Map.Entry<String, String> e : fingerprints.entrySet()) {
                this.add(e.getKey(), e.getValue());
            }
        }
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public CertificateFingerprintHostnameVerifier add(String hostname, String fingerprint) {
        String lhostname;
        String string = lhostname = hostname != null ? hostname.toLowerCase(Locale.ROOT) : null;
        if (lhostname != null && fingerprint != null) {
            this.fingerprints.put(lhostname, fingerprint.replaceAll("[^a-zA-Z0-9]", "").toLowerCase(Locale.ROOT));
        }
        return this;
    }

    protected Certificate extractCertificate(SSLSession sslSession) {
        Certificate result = null;
        try {
            Certificate[] cs;
            if (sslSession != null && (cs = sslSession.getPeerCertificates()) != null && cs.length > 0) {
                result = cs[0];
            }
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        return result;
    }

    protected void verify(String host, X509Certificate cert) throws SSLException {
        boolean ipv4 = InetAddressUtils.isIPv4Address((String)host);
        boolean ipv6 = InetAddressUtils.isIPv6Address((String)host);
        int subjectType = !ipv4 && !ipv6 ? 2 : 7;
        List<String> subjectAlts = this.extractSubjectAlts(cert, subjectType);
        if (subjectAlts != null && !subjectAlts.isEmpty()) {
            if (ipv4) {
                this.matchIPAddress(host, subjectAlts);
            } else if (ipv6) {
                this.matchIPv6Address(host, subjectAlts);
            } else {
                this.matchDNSName(host, subjectAlts, this.publicSuffixMatcher);
            }
        } else {
            X500Principal subjectPrincipal = cert.getSubjectX500Principal();
            String cn = this.extractCN(subjectPrincipal.getName("RFC2253"));
            if (cn == null) {
                throw new SSLException("Certificate subject for <" + host + "> doesn't contain " + "a common name and does not have alternative names");
            }
            this.matchCN(host, cn, this.publicSuffixMatcher);
        }
    }

    protected void matchIPAddress(String host, List<String> subjectAlts) throws SSLException {
        for (int i = 0; i < subjectAlts.size(); ++i) {
            String subjectAlt = subjectAlts.get(i);
            if (!host.equals(subjectAlt)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + host + "> doesn't match any " + "of the subject alternative names: " + subjectAlts);
    }

    protected void matchIPv6Address(String host, List<String> subjectAlts) throws SSLException {
        String normalisedHost = this.normaliseAddress(host);
        for (int i = 0; i < subjectAlts.size(); ++i) {
            String subjectAlt = subjectAlts.get(i);
            String normalizedSubjectAlt = this.normaliseAddress(subjectAlt);
            if (!normalisedHost.equals(normalizedSubjectAlt)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + host + "> doesn't match any " + "of the subject alternative names: " + subjectAlts);
    }

    protected void matchDNSName(String host, List<String> subjectAlts, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        String normalizedHost = host.toLowerCase(Locale.ROOT);
        for (int i = 0; i < subjectAlts.size(); ++i) {
            String subjectAlt = subjectAlts.get(i);
            String normalizedSubjectAlt = subjectAlt.toLowerCase(Locale.ROOT);
            if (!this.matchIdentityStrict(normalizedHost, normalizedSubjectAlt, publicSuffixMatcher)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + host + "> doesn't match any " + "of the subject alternative names: " + subjectAlts);
    }

    protected void matchCN(String host, String cn, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        if (!this.matchIdentityStrict(host, cn, publicSuffixMatcher)) {
            throw new SSLException("Certificate for <" + host + "> doesn't match " + "common name of the certificate subject: " + cn);
        }
    }

    protected String extractCN(String subjectPrincipal) throws SSLException {
        if (subjectPrincipal == null) {
            return null;
        }
        try {
            LdapName e = new LdapName(subjectPrincipal);
            List<Rdn> rdns = e.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rds = rdns.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object ignore = cn.get();
                    if (ignore == null) continue;
                    return ignore.toString();
                }
                catch (NoSuchElementException var8) {
                    continue;
                }
                catch (NamingException var9) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (InvalidNameException var10) {
            throw new SSLException(subjectPrincipal + " is not a valid X500 distinguished name");
        }
    }

    protected List<String> extractSubjectAlts(X509Certificate cert, int subjectType) {
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException var9) {
            // empty catch block
        }
        ArrayList<String> subjectAltList = null;
        if (c != null) {
            for (List<?> aC : c) {
                int type = (Integer)aC.get(0);
                if (type != subjectType) continue;
                String s = (String)aC.get(1);
                if (subjectAltList == null) {
                    subjectAltList = new ArrayList<String>();
                }
                subjectAltList.add(s);
            }
        }
        return subjectAltList;
    }

    protected String normaliseAddress(String hostname) {
        if (hostname == null) {
            return hostname;
        }
        try {
            InetAddress unexpected = InetAddress.getByName(hostname);
            return unexpected.getHostAddress();
        }
        catch (UnknownHostException var2) {
            return hostname;
        }
    }

    protected boolean matchDomainRoot(String host, String domainRoot) {
        return domainRoot == null ? false : host.endsWith(domainRoot) && (host.length() == domainRoot.length() || host.charAt(host.length() - domainRoot.length() - 1) == '.');
    }

    protected boolean matchIdentity(String host, String identity, PublicSuffixMatcher publicSuffixMatcher, boolean strict) {
        if (publicSuffixMatcher != null && host.contains(".") && !this.matchDomainRoot(host, publicSuffixMatcher.getDomainRoot(identity, DomainType.ICANN))) {
            return false;
        }
        int asteriskIdx = identity.indexOf(42);
        if (asteriskIdx != -1) {
            String remainder;
            String prefix = identity.substring(0, asteriskIdx);
            String suffix = identity.substring(asteriskIdx + 1);
            if (!prefix.isEmpty() && !host.startsWith(prefix)) {
                return false;
            }
            if (!suffix.isEmpty() && !host.endsWith(suffix)) {
                return false;
            }
            return !strict || !(remainder = host.substring(prefix.length(), host.length() - suffix.length())).contains(".");
        }
        return host.equalsIgnoreCase(identity);
    }

    protected boolean matchIdentity(String host, String identity, PublicSuffixMatcher publicSuffixMatcher) {
        return this.matchIdentity(host, identity, publicSuffixMatcher, false);
    }

    protected boolean matchIdentity(String host, String identity) {
        return this.matchIdentity(host, identity, null, false);
    }

    protected boolean matchIdentityStrict(String host, String identity, PublicSuffixMatcher publicSuffixMatcher) {
        return this.matchIdentity(host, identity, publicSuffixMatcher, true);
    }

    protected boolean matchIdentityStrict(String host, String identity) {
        return this.matchIdentity(host, identity, null, true);
    }

    protected boolean verifyFingerprint(String hostname, Certificate c) throws CertificateEncodingException {
        boolean result = false;
        if (!this.fingerprints.isEmpty()) {
            String actualFingerprint = DigestUtils.sha256Hex((byte[])c.getEncoded());
            String expectedFingerprint = this.fingerprints.get(hostname);
            result |= actualFingerprint.equals(expectedFingerprint);
        }
        return result;
    }

    @Override
    public boolean verify(String s, SSLSession sslSession) {
        Certificate c = this.extractCertificate(sslSession);
        boolean result = false;
        if (c != null) {
            try {
                this.verify(s, (X509Certificate)c);
                if (!this.verifyFingerprint(s, c)) {
                    throw new SSLException("known fingerprint for the known certificate for host " + s + " does not match with actual");
                }
                result = true;
            }
            catch (SSLException e) {
                result &= false;
            }
            catch (CertificateEncodingException e) {
                result &= false;
            }
        }
        return result;
    }
}

