/*
 * Decompiled with CFR 0.152.
 */
package me.sniggle.common.http;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.commons.codec.digest.DigestUtils;

public class CalculateCertificateHash {
    private String certificatePath;
    private Certificate certificate;

    public CalculateCertificateHash(String path) {
        this.certificatePath = path;
    }

    public boolean validateCertificate() {
        Path certificateDirectory;
        boolean result = false;
        if (this.certificatePath != null && Files.exists(certificateDirectory = Paths.get(this.certificatePath, new String[0]), new LinkOption[0])) {
            try {
                this.certificate = CertificateFactory.getInstance("X.509").generateCertificate(Files.newInputStream(certificateDirectory, new OpenOption[0]));
                result = true;
            }
            catch (IOException | CertificateException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String calculateHash() {
        String result = null;
        if (this.certificate != null) {
            try {
                result = DigestUtils.sha256Hex((byte[])this.certificate.getEncoded());
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        CalculateCertificateHash calculateCertificateHash;
        if (args.length == 1 && (calculateCertificateHash = new CalculateCertificateHash(args[0])).validateCertificate()) {
            System.out.print(calculateCertificateHash.calculateHash());
        }
    }
}

