/*
 * Decompiled with CFR 0.152.
 */
package sneer.rx;

import rx.Observable;
import rx.Observer;
import rx.functions.Action1;
import rx.subjects.BehaviorSubject;
import rx.subjects.Subject;
import sneer.rx.Observed;

public class ObservedSubject<T>
implements Observer<T> {
    private volatile T mostRecent;
    private final Subject<T, T> subject;

    public static <T> ObservedSubject<T> createWithSubject(Subject<T, T> subject) {
        return new ObservedSubject<T>(subject);
    }

    public static <T> ObservedSubject<T> create(T initialValue) {
        return new ObservedSubject<T>(initialValue);
    }

    private ObservedSubject(T initialValue) {
        this((Subject<T, T>)BehaviorSubject.create(initialValue));
    }

    public ObservedSubject(Subject<T, T> subject) {
        this.subject = subject;
        subject.subscribe(new Action1<T>(){

            public void call(T newValue) {
                ObservedSubject.this.mostRecent = newValue;
            }
        });
    }

    public Observed<T> observed() {
        return new Observed<T>(){

            @Override
            public T current() {
                return ObservedSubject.this.mostRecent;
            }

            @Override
            public Observable<T> observable() {
                return ObservedSubject.this.subject.asObservable();
            }
        };
    }

    public Observable<T> observable() {
        return this.subject.asObservable();
    }

    public T current() {
        return this.mostRecent;
    }

    public void onCompleted() {
        this.subject.onCompleted();
    }

    public void onError(Throwable e) {
        this.subject.onError(e);
    }

    public void onNext(T newValue) {
        this.subject.onNext(newValue);
    }
}

