/*
 * Decompiled with CFR 0.152.
 */
package sneer.commons;

import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.ocpsoft.prettytime.PrettyTime;
import rx.Observable;
import rx.subjects.BehaviorSubject;
import sneer.commons.Clock;

public class SystemReport {
    private static final BehaviorSubject<String> subject = BehaviorSubject.create((Object)"");
    private static final SortedMap<String, Object> infosByTag = new TreeMap<String, Object>();

    public static Observable<String> report() {
        return subject.asObservable();
    }

    public static void updateReport(String tag) {
        SystemReport.updateReport(tag, new Date());
    }

    public static void updateReport(String tag, Object info) {
        subject.onNext((Object)SystemReport.updateReportAndGetLatest(tag, info));
    }

    private static synchronized String updateReportAndGetLatest(String tag, Object info) {
        String msg = SystemReport.pretty(new Date(Clock.now())) + " " + info;
        System.out.println(tag + ":" + msg);
        infosByTag.put(tag, msg);
        return SystemReport.latestReport();
    }

    private static String latestReport() {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<String, Object> entry : infosByTag.entrySet()) {
            ret.append(entry.getKey()).append(": ").append(SystemReport.pretty(entry.getValue())).append("\n\n");
        }
        return ret.toString();
    }

    private static String pretty(Object info) {
        Object ret = info;
        if (ret instanceof Date) {
            ret = new PrettyTime().format((Date)ret);
        }
        return ret.toString();
    }
}

