/*
 * Decompiled with CFR 0.152.
 */
package sneer.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sneer.commons.ObjectReplacer;

public class InteractiveSerializer {
    private ConcurrentMap<Class<?>, ObjectReplacer> localTypes = new ConcurrentHashMap();
    private ConcurrentMap<Class<?>, ObjectReplacer> remoteTypes = new ConcurrentHashMap();

    public <LocalType, RemoteType extends LocalType> void registerReplacer(Class<LocalType> local, Class<RemoteType> remote, ObjectReplacer<LocalType, RemoteType> replacer) {
        this.localTypes.put(local, replacer);
        this.remoteTypes.put(remote, replacer);
    }

    public byte[] serialize(Object obj) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bytes){
                {
                    if (!InteractiveSerializer.this.localTypes.isEmpty()) {
                        this.enableReplaceObject(true);
                    }
                }

                @Override
                protected Object replaceObject(Object obj) throws IOException {
                    ObjectReplacer replacer = (ObjectReplacer)InteractiveSerializer.resolveAndCacheInstanceOf(InteractiveSerializer.this.localTypes, obj.getClass());
                    return replacer != null ? replacer.outgoing(obj) : super.replaceObject(obj);
                }
            };
            out.writeObject(obj);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T resolveAndCacheInstanceOf(Map<Class<?>, T> map, Class<?> originalClass) {
        Class<?> candidate;
        Object ret = null;
        try {
            for (candidate = originalClass; candidate != Object.class; candidate = candidate.getSuperclass()) {
                Class<?>[] ifaces;
                ret = map.get(candidate);
                if (ret != null) {
                    Object v = ret;
                    return (T)v;
                }
                for (Class<?> iface : ifaces = candidate.getInterfaces()) {
                    ret = map.get(iface);
                    if (ret == null) continue;
                    candidate = iface;
                    Object v = ret;
                    return (T)v;
                }
            }
        }
        finally {
            if (ret != null && candidate != originalClass) {
                map.put(candidate, ret);
            }
        }
        return (T)ret;
    }

    public Object deserialize(byte[] bytes) {
        try {
            return new ObjectInputStream(new ByteArrayInputStream(bytes)){
                {
                    if (!InteractiveSerializer.this.remoteTypes.isEmpty()) {
                        this.enableResolveObject(true);
                    }
                }

                @Override
                protected Object resolveObject(Object obj) throws IOException {
                    ObjectReplacer replacer = (ObjectReplacer)InteractiveSerializer.resolveAndCacheInstanceOf(InteractiveSerializer.this.remoteTypes, obj.getClass());
                    return replacer != null ? replacer.incoming(obj) : super.resolveObject(obj);
                }
            }.readObject();
        }
        catch (OptionalDataException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

