/*
 * Decompiled with CFR 0.152.
 */
package sneer.commons;

import sneer.commons.exceptions.Exceptions;

public class Clock {
    private static volatile long now = -1L;

    public static void startMocking() {
        Exceptions.check(!Clock.isMocked());
        now = 0L;
    }

    public static void stopMocking() {
        Exceptions.check(Clock.isMocked());
        now = -1L;
    }

    public static void advance(long millis) {
        Exceptions.check(millis > 0L);
        Exceptions.check(Clock.isMocked());
        now += millis;
    }

    public static void tick() {
        Clock.advance(1L);
    }

    public static long now() {
        return Clock.isMocked() ? now : System.currentTimeMillis();
    }

    private static boolean isMocked() {
        return now != -1L;
    }
}

