/*
 * Decompiled with CFR 0.152.
 */
package sneer.android;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Messenger;
import android.os.Parcelable;
import android.widget.Toast;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import sneer.android.FromSneerHandler;
import sneer.android.Message;
import sneer.android.impl.Envelope;
import sneer.android.ui.SneerInstallation;

public class PartnerSession
implements Closeable {
    private final Context context;
    private Intent intent;
    private final Listener listener;
    private final CountDownLatch connectionPending = new CountDownLatch(1);
    private final ServiceConnection connection = this.createConnection();
    private Messenger toSneer;
    private boolean wasBound;
    private boolean isUpToDate = false;

    public static PartnerSession join(Activity activity, Listener listener) {
        return PartnerSession.join((Context)activity, activity.getIntent(), listener);
    }

    public static PartnerSession join(Context context, Intent intent, Listener listener) {
        return new PartnerSession(context, intent, listener);
    }

    public boolean wasStartedByMe() {
        if (!this.intent.hasExtra("IS_OWN")) {
            throw new IllegalStateException("Unable to determine who started the session.");
        }
        return this.intent.getBooleanExtra("IS_OWN", false);
    }

    public void send(Object payload) {
        PartnerSession.await(this.connectionPending);
        this.sendToSneer(payload);
    }

    @Override
    public void close() {
        if (this.wasBound) {
            this.context.unbindService(this.connection);
        }
    }

    private ServiceConnection createConnection() {
        return new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                PartnerSession.this.toSneer = new Messenger(service);
                Messenger callback = new Messenger((Handler)new FromSneerHandler(PartnerSession.this));
                PartnerSession.this.sendToSneer(callback);
                PartnerSession.this.connectionPending.countDown();
            }

            public void onServiceDisconnected(ComponentName name) {
                PartnerSession.this.toSneer = null;
                PartnerSession.this.finish("Connection to Sneer was lost");
                PartnerSession.this.connectionPending.countDown();
            }
        };
    }

    private PartnerSession(Context context_, Intent intent_, Listener listener) {
        this.context = context_;
        this.intent = intent_;
        this.listener = listener;
        Intent sneer = (Intent)this.intent.getParcelableExtra("JOIN_SESSION");
        if (sneer == null) {
            this.handleSneerNotfound();
            return;
        }
        this.wasBound = this.context.bindService(sneer, this.connection, 65);
        if (!this.wasBound) {
            this.finish("Unable to connect to Sneer");
        }
    }

    private void handleSneerNotfound() {
        String message = this.context.getClass().getSimpleName() + ": Make sure Sneer session metadata is correctly set in your AndroidManifest.xml file";
        if (this.context instanceof Activity) {
            if (SneerInstallation.checkConversationContext((Activity)this.context)) {
                this.finish(message);
            }
        } else {
            throw new IllegalStateException(message);
        }
    }

    private void finish(String endingToast) {
        this.toast(endingToast);
        if (this.context instanceof Activity) {
            ((Activity)this.context).finish();
        }
    }

    void handleMessageFromSneer(android.os.Message msg) {
        Bundle data = msg.getData();
        data.setClassLoader(this.getClass().getClassLoader());
        Object content = ((Envelope)data.getParcelable((String)"ENVELOPE")).content;
        if (content.equals("UP_TO_DATE")) {
            this.isUpToDate = true;
        } else {
            this.listener.onMessage(this.getMessage(content));
        }
        if (this.isUpToDate) {
            this.handleUpToDate();
        }
    }

    private void handleUpToDate() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PartnerSession.this.listener.onUpToDate();
            }
        };
        if (this.context instanceof Activity) {
            ((Activity)this.context).runOnUiThread(runnable);
        } else {
            runnable.run();
        }
    }

    private void sendToSneer(Object data) {
        android.os.Message msg = this.asMessage(data);
        try {
            this.doSendToSneer(msg);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private android.os.Message asMessage(Object data) {
        android.os.Message ret = android.os.Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putParcelable("ENVELOPE", (Parcelable)Envelope.envelope(data));
        ret.setData(bundle);
        return ret;
    }

    private void doSendToSneer(android.os.Message msg) throws Exception {
        if (this.toSneer == null) {
            this.toast("No connection to Sneer");
            return;
        }
        this.toSneer.send(msg);
    }

    private Message getMessage(Object content) {
        final Map map = (Map)content;
        return new Message(){

            @Override
            public boolean wasSentByMe() {
                return (Boolean)map.get("IS_OWN");
            }

            @Override
            public Object payload() {
                return map.get("PAYLOAD");
            }
        };
    }

    private void handleException(Exception e) {
        e.printStackTrace();
        this.toast(e.getMessage());
    }

    private void toast(String message) {
        Toast.makeText((Context)this.context, (CharSequence)message, (int)1).show();
    }

    private static void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Listener {
        public void onUpToDate();

        public void onMessage(Message var1);
    }
}

