/*
 * Decompiled with CFR 0.152.
 */
package sneer.android;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Messenger;
import android.os.Parcelable;
import android.widget.Toast;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import sneer.android.FromSneerHandler;
import sneer.android.Message;
import sneer.android.impl.Envelope;
import sneer.android.ui.SneerInstallation;

public class PartnerSession
implements Closeable {
    private boolean isBound;
    private final Activity activity;
    private final Listener listener;
    private final CountDownLatch connectionPending = new CountDownLatch(1);
    private final ServiceConnection connection = this.createConnection();
    private boolean isUpToDate = false;
    private Messenger toSneer;

    public static PartnerSession join(Activity activity, Listener listener) {
        return new PartnerSession(activity, listener);
    }

    public boolean wasStartedByMe() {
        Intent intent = this.activity.getIntent();
        if (!intent.hasExtra("IS_OWN")) {
            throw new IllegalStateException("Unable to determine who started the session.");
        }
        return intent.getBooleanExtra("IS_OWN", false);
    }

    public void send(Object payload) {
        PartnerSession.await(this.connectionPending);
        this.sendToSneer(payload);
    }

    @Override
    public void close() {
        if (this.isBound) {
            this.activity.unbindService(this.connection);
        }
    }

    private ServiceConnection createConnection() {
        return new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                PartnerSession.this.toSneer = new Messenger(service);
                Messenger callback = new Messenger((Handler)new FromSneerHandler(PartnerSession.this));
                PartnerSession.this.sendToSneer(callback);
                PartnerSession.this.connectionPending.countDown();
            }

            public void onServiceDisconnected(ComponentName name) {
                PartnerSession.this.toSneer = null;
                PartnerSession.this.finish("Connection to Sneer was lost");
                PartnerSession.this.connectionPending.countDown();
            }
        };
    }

    private PartnerSession(Activity activity, Listener listener) {
        this.activity = activity;
        this.listener = listener;
        Intent sneer = (Intent)activity.getIntent().getParcelableExtra("JOIN_SESSION");
        if (sneer == null) {
            if (SneerInstallation.checkConversationContext(activity)) {
                this.finish(activity.getLocalClassName() + ": Make sure Sneer session metadata is correctly set in your AndroidManifest.xml file");
            }
            return;
        }
        this.isBound = activity.bindService(sneer, this.connection, 65);
        if (!this.isBound) {
            this.finish("Unable to connect to Sneer");
        }
    }

    private void finish(String endingToast) {
        this.toast(endingToast);
        this.activity.finish();
    }

    public void handleMessageFromSneer(android.os.Message msg) {
        Bundle data = msg.getData();
        data.setClassLoader(this.getClass().getClassLoader());
        Object content = ((Envelope)data.getParcelable((String)"ENVELOPE")).content;
        if (content.equals("UP_TO_DATE")) {
            this.isUpToDate = true;
        } else {
            this.listener.onMessage(this.getMessage(content));
        }
        if (this.isUpToDate) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PartnerSession.this.listener.onUpToDate();
                }
            });
        }
    }

    private void sendToSneer(Object data) {
        android.os.Message msg = this.asMessage(data);
        try {
            this.doSendToSneer(msg);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private android.os.Message asMessage(Object data) {
        android.os.Message ret = android.os.Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putParcelable("ENVELOPE", (Parcelable)Envelope.envelope(data));
        ret.setData(bundle);
        return ret;
    }

    private void doSendToSneer(android.os.Message msg) throws Exception {
        if (this.toSneer == null) {
            this.toast("No connection to Sneer");
            return;
        }
        this.toSneer.send(msg);
    }

    private Message getMessage(Object content) {
        final Map map = (Map)content;
        return new Message(){

            @Override
            public boolean wasSentByMe() {
                return (Boolean)map.get("IS_OWN");
            }

            @Override
            public Object payload() {
                return map.get("PAYLOAD");
            }
        };
    }

    private void handleException(Exception e) {
        e.printStackTrace();
        this.toast(e.getMessage());
    }

    private void toast(String message) {
        Toast.makeText((Context)this.activity, (CharSequence)message, (int)1).show();
    }

    private static void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Listener {
        public void onUpToDate();

        public void onMessage(Message var1);
    }
}

