/*
 * Decompiled with CFR 0.152.
 */
package sneer.android.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;

public class SneerInstallation {
    public static boolean checkConversationContext(Activity activity) {
        if (SneerInstallation.wasCalledFromConversation(activity)) {
            return true;
        }
        SneerInstallation.promptNeedForSneerConversation(activity);
        return false;
    }

    private static void promptNeedForSneerConversation(Activity activity) {
        Intent sneer = activity.getPackageManager().getLaunchIntentForPackage("sneer.main");
        if (sneer == null) {
            SneerInstallation.start(SneerInstallation.market(), activity, "To use this app you need to install the Sneer chat app.", "Install Sneer");
        } else {
            SneerInstallation.start(sneer, activity, "This app must be used inside a Sneer conversation.", "Open Sneer");
        }
    }

    private static Intent market() {
        Intent ret = new Intent("android.intent.action.VIEW");
        ret.setData(Uri.parse((String)"https://play.google.com/store/apps/details?id=sneer.main"));
        return ret;
    }

    private static boolean wasCalledFromConversation(Activity activity) {
        return activity.getIntent().getParcelableExtra("SEND_MESSAGE") != null;
    }

    private static void start(final Intent intent, final Activity activity, String message, String buttonText) {
        AlertDialog alert = new AlertDialog.Builder((Context)activity).setMessage((CharSequence)message).setPositiveButton((CharSequence)buttonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int option) {
                intent.addFlags(0x10000000);
                activity.startActivity(intent);
                activity.finish();
            }
        }).setIcon(17301543).create();
        alert.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                activity.finish();
            }
        });
        alert.show();
    }
}

