/*
 * Decompiled with CFR 0.152.
 */
package sneer.android;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import sneer.android.Messages;
import sneer.android.impl.SharedResultReceiver;
import sneer.android.impl.Utils;
import sneer.android.impl.Value;

public class PartnerSession {
    private final Listener listener;
    private final ClassLoader classLoader;
    private final ResultReceiver toSneer;
    private boolean isReplaying;

    public PartnerSession(Context context, Intent intent, Listener listener) {
        this.listener = listener;
        this.classLoader = context.getClassLoader();
        this.toSneer = this.resultReceiver(intent);
        this.toSneer.send(0, this.hail());
    }

    private Bundle hail() {
        Bundle hail = new Bundle();
        hail.putParcelable("result", (Parcelable)new SharedResultReceiver(new SharedResultReceiver.Callback(){

            @Override
            public void call(Bundle received) {
                received.setClassLoader(PartnerSession.this.classLoader);
                PartnerSession.this.handlePartnerName(received);
                PartnerSession.this.handlePayload(received);
                PartnerSession.this.handleRefresh(received);
            }
        }));
        return hail;
    }

    private void handlePartnerName(Bundle received) {
        String partnerName = received.getString("partnerName");
        if (partnerName != null) {
            this.listener.onPartnerName(partnerName);
        }
    }

    private void handlePayload(Bundle received) {
        Object messageEnvelope = received.get("payload");
        if (messageEnvelope == null) {
            return;
        }
        Object message = ((Value)messageEnvelope).get();
        boolean mine = received.getBoolean("own");
        if (mine) {
            this.listener.onMessageToPartner(message);
        } else {
            this.listener.onMessageFromPartner(message);
        }
    }

    private void handleRefresh(Bundle received) {
        if (received.getBoolean("replayFinished")) {
            this.isReplaying = false;
        }
        if (!this.isReplaying) {
            this.listener.update();
        }
    }

    private ResultReceiver resultReceiver(Intent intent) {
        return (ResultReceiver)Utils.getExtra(intent, "result");
    }

    public void dispose() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("unsubscribe", true);
        this.toSneer.send(0, bundle);
    }

    public void send(String label, Object message) {
        Messages.send(this.toSneer, label, message, null);
    }

    public static interface Listener {
        public void onPartnerName(String var1);

        public void onMessageToPartner(Object var1);

        public void onMessageFromPartner(Object var1);

        public void update();
    }
}

