/*
 * Decompiled with CFR 0.152.
 */
package me.smecsia.gawain.jdbc.dialect;

import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.smecsia.gawain.jdbc.dialect.Dialect;
import me.smecsia.gawain.jdbc.util.ThreadUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class BasicDialect
implements Dialect,
GroovyObject {
    private int maxObjectSize;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public BasicDialect() {
        MetaClass metaClass;
        int n;
        this.maxObjectSize = n = 30720;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void createLocksTableIfNotExists(String tableName, Connection conn) throws SQLException {
        conn.createStatement().execute(this.createLocksSQL(tableName));
    }

    @Override
    public void createRepoTableIfNotExists(String tableName, Connection conn) throws SQLException {
        conn.createStatement().execute(this.createRepoSQL(tableName));
    }

    @Override
    public void tryLock(String tableName, String key, Connection conn) throws SQLException {
        conn.createStatement().execute(this.insertLockSQL(tableName, key));
    }

    @Override
    public void tryUnlock(String tableName, String key, Connection conn) throws SQLException {
        conn.createStatement().execute(this.removeLockSQL(tableName, key));
    }

    @Override
    public boolean isLocked(String tableName, String key, Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), key}, new String[]{"SELECT * FROM ", " WHERE ", "='", "'"})));
        return statement.getResultSet().next();
    }

    @Override
    public boolean isLockedByMe(String tableName, String key, Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), key}, new String[]{"SELECT * FROM ", " WHERE ", "='", "' "}).plus((GString)new GStringImpl(new Object[]{this.field("thread_id"), ThreadUtil.threadId()}, new String[]{"AND ", " ='", "'"}))));
        return statement.getResultSet().next();
    }

    @Override
    public void put(String tableName, String key, Connection conn, byte ... bytes) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(this.upsertSQL(tableName));
        statement.setString(1, key);
        statement.setBytes(2, bytes);
        statement.executeUpdate();
    }

    @Override
    public void remove(String tableName, String key, Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.executeUpdate(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), key}, new String[]{"DELETE FROM ", " WHERE ", " = '", "'"})));
    }

    @Override
    public byte[] get(String tableName, String key, Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), key}, new String[]{"SELECT object FROM ", " WHERE ", " = '", "'"})));
        return (byte[])ScriptBytecodeAdapter.castToType(statement.getResultSet().next() ? statement.getResultSet().getBytes("object") : null, byte[].class);
    }

    @Override
    public Collection<String> keys(String tableName, Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.field("key"), this.table(tableName)}, new String[]{"SELECT ", " FROM ", ""})));
        List res = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (statement.getResultSet().next()) {
            DefaultGroovyMethods.leftShift((List)res, (Object)statement.getResultSet().getString("key"));
        }
        return res;
    }

    @Override
    public Map<String, byte[]> valuesMap(String tableName, Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.field("key"), this.field("object"), this.table(tableName)}, new String[]{"SELECT ", ", ", " FROM ", ""})));
        LinkedHashMap res = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        while (statement.getResultSet().next()) {
            byte[] byArray = statement.getResultSet().getBytes("object");
            DefaultGroovyMethods.putAt((Map)res, (Object)statement.getResultSet().getString("key"), (Object)byArray);
        }
        return res;
    }

    protected String table(String name) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}));
    }

    protected String field(String name) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}));
    }

    protected String upsertSQL(String tableName) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), this.field("object")}, new String[]{"\n             MERGE INTO ", "(", ", ", ") VALUES (?, ?)\n        "}));
    }

    protected String insertLockSQL(String tableName, String key) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), this.field("locked_date"), this.field("thread_id"), key, ThreadUtil.threadId()}, new String[]{"\n            INSERT INTO ", " (", ", ", ", ", ")\n                    VALUES ('", "', current_date() - 100, '", "')\n        "}));
    }

    protected String createLocksSQL(String tableName) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), this.field("locked_date"), this.field("thread_id"), this.field("key")}, new String[]{"\n            CREATE TABLE IF NOT EXISTS ", " (\n              ", " VARCHAR(512),\n              ", " DATE,\n              ", " VARCHAR(256),\n              PRIMARY KEY (", ")\n            )\n        "}));
    }

    protected String createRepoSQL(String tableName) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), this.field("object"), this.maxObjectSize, this.field("key")}, new String[]{"\n            CREATE TABLE IF NOT EXISTS ", " (\n              ", " VARCHAR(512),\n              ", " VARBINARY(", "),\n              PRIMARY KEY (", ")\n            )\n        "}));
    }

    protected String removeLockSQL(String tableName, String key) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.table(tableName), this.field("key"), key}, new String[]{"\n            DELETE FROM ", " WHERE ", "='", "'\n        "}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BasicDialect.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

