/*
 * Decompiled with CFR 0.152.
 */
package me.smecsia.gawain.jdbc;

import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Map;
import java.util.Set;
import me.smecsia.gawain.Repository;
import me.smecsia.gawain.Serializer;
import me.smecsia.gawain.error.LockWaitTimeoutException;
import me.smecsia.gawain.impl.FSTSerializer;
import me.smecsia.gawain.jdbc.JDBCPessimisticLocking;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCRepo
implements Repository,
GroovyObject {
    private static final Logger LOGGER;
    private final String tableName;
    private final JDBCPessimisticLocking locking;
    private final Serializer<Map> serializer;
    private final int maxLockWaitMs;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public JDBCRepo(String string, JDBCPessimisticLocking jDBCPessimisticLocking, int n, Serializer<Map> serializer) {
        void serializer2;
        void maxLockWaitMs;
        void locking;
        void tableName;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Repository.Trait.Helper.$init$((Repository)this);
        void var6_6 = tableName;
        this.tableName = var6_6;
        void var7_7 = locking;
        this.locking = var7_7;
        void var8_8 = maxLockWaitMs;
        this.maxLockWaitMs = var8_8;
        void var9_9 = serializer2;
        this.serializer = var9_9;
        locking.getDialect().createRepoTableIfNotExists((String)tableName, locking.getConnection());
    }

    public JDBCRepo(String tableName, JDBCPessimisticLocking locking, int maxLockWaitMs) {
        this(tableName, locking, maxLockWaitMs, (Serializer<Map>)((Serializer)new FSTSerializer()));
    }

    public JDBCRepo(String tableName, JDBCPessimisticLocking locking) {
        this(tableName, locking, 5000, (Serializer<Map>)((Serializer)new FSTSerializer()));
    }

    public Map get(String key) {
        byte[] data = this.locking.getDialect().get(this.tableName, key, this.locking.getConnection());
        return (Map)ScriptBytecodeAdapter.castToType(data != null ? this.serializer.fromBytes(data) : null, Map.class);
    }

    public boolean isLockedByMe(String key) {
        return this.locking.isLockedByMe(key);
    }

    public Set<String> keys() {
        this.locking.getDialect().keys(this.tableName, this.locking.getConnection());
        return (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
    }

    public Map<String, Map> values() {
        class _values_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _values_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object res, Map.Entry<String, byte[]> e) {
                Object object = e.getValue() != null ? ((JDBCRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), JDBCRepo.class)).getSerializer().fromBytes((byte[])ScriptBytecodeAdapter.castToType((Object)e.getValue(), byte[].class)) : null;
                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)res, Map.class)), (Object)e.getKey(), object);
                return object;
            }

            public Object call(Object res, Map.Entry<String, byte[]> e) {
                return this.doCall(res, e);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _values_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Map)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.inject(this.locking.getDialect().valuesMap(this.tableName, this.locking.getConnection()), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Closure)new _values_closure1(this, this)), Map.class);
    }

    public Map lockAndGet(String key) throws LockWaitTimeoutException {
        this.locking.tryLock(key, this.maxLockWaitMs);
        byte[] bytes = this.locking.getDialect().get(this.tableName, key, this.locking.getConnection());
        return (Map)ScriptBytecodeAdapter.castToType(bytes != null ? this.serializer.fromBytes(bytes) : null, Map.class);
    }

    public void lock(String key) throws LockWaitTimeoutException {
        this.locking.tryLock(key, this.maxLockWaitMs);
    }

    public boolean tryLock(String key) {
        this.locking.tryLock(key, this.maxLockWaitMs);
        boolean bl = true;
        try {
            return bl;
        }
        catch (LockWaitTimeoutException e) {
            LOGGER.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key, this.maxLockWaitMs}, new String[]{"Failed to lock key '", "' within ", "ms"})), (Throwable)e);
            boolean bl2 = false;
            return bl2;
        }
    }

    public void unlock(String key) {
        this.locking.unlock(key);
    }

    public Map putAndUnlock(String key, Map value) {
        this.locking.getDialect().put(this.tableName, key, this.locking.getConnection(), this.serializer.toBytes((Object)value));
        this.locking.unlock(key);
        return value;
    }

    public Map put(String key, Map value) {
        this.locking.getDialect().put(this.tableName, key, this.locking.getConnection(), this.serializer.toBytes((Object)value));
        return value;
    }

    public Object deleteAndUnlock(String key) {
        this.locking.getDialect().remove(this.tableName, key, this.locking.getConnection());
        return null;
    }

    @Traits.TraitBridge(traitClass=Repository.class, desc="(Ljava/lang/String;)Ljava/util/Map;")
    public Map getAt(String arg1) {
        return Repository.Trait.Helper.getAt((Repository)this, (String)arg1);
    }

    public /* synthetic */ Map me_smecsia_gawain_Repositorytrait$super$getAt(String param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getAt", (Object)new Object[]{param0}), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Object)this, (String)param0), Map.class);
    }

    @Traits.TraitBridge(traitClass=Repository.class, desc="(Ljava/lang/String;Lme/smecsia/gawain/Repository$StateClosure;)Ljava/util/Map;")
    public Map with(String arg1, Repository.StateClosure arg2) throws LockWaitTimeoutException {
        return Repository.Trait.Helper.with((Repository)this, (String)arg1, (Repository.StateClosure)arg2);
    }

    public /* synthetic */ Map me_smecsia_gawain_Repositorytrait$super$with(String param0, Repository.StateClosure param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"with", (Object)new Object[]{param0, param1}), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"with", (Object[])new Object[]{param0, param1}), Map.class);
    }

    @Traits.TraitBridge(traitClass=Repository.class, desc="(Lme/smecsia/gawain/Repository$StateClosure;)Ljava/lang/Object;")
    public Object withEach(Repository.StateClosure arg1) throws LockWaitTimeoutException {
        return Repository.Trait.Helper.withEach((Repository)this, (Repository.StateClosure)arg1);
    }

    public /* synthetic */ Object me_smecsia_gawain_Repositorytrait$super$withEach(Repository.StateClosure param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"withEach", (Object)new Object[]{param0});
        }
        return ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"withEach", (Object[])new Object[]{param0});
    }

    static {
        Logger logger;
        LOGGER = logger = LoggerFactory.getLogger(JDBCRepo.class);
        Repository.Trait.Helper.$static$init$(JDBCRepo.class);
    }

    public static /* synthetic */ Serializer<Map> pfaccess$0(JDBCRepo $that) {
        return $that.getSerializer();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JDBCRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static final Logger getLOGGER() {
        return LOGGER;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final JDBCPessimisticLocking getLocking() {
        return this.locking;
    }

    public final Serializer<Map> getSerializer() {
        return this.serializer;
    }

    public final int getMaxLockWaitMs() {
        return this.maxLockWaitMs;
    }
}

