/*
 * Decompiled with CFR 0.152.
 */
package me.smecsia.gawain.jdbc;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.sql.Connection;
import java.sql.SQLException;
import me.smecsia.gawain.error.InvalidLockOwnerException;
import me.smecsia.gawain.error.LockWaitTimeoutException;
import me.smecsia.gawain.jdbc.dialect.BasicDialect;
import me.smecsia.gawain.jdbc.dialect.Dialect;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPessimisticLocking
implements GroovyObject {
    private static final Logger LOGGER;
    private final String tableName;
    private final Connection connection;
    private final Dialect dialect;
    private final long lockPollIntervalMs;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public JDBCPessimisticLocking(String string, Connection connection, long l, Dialect dialect) {
        void lockPollIntervalMs;
        void dialect2;
        void connection2;
        void tableName;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var7_6 = tableName;
        this.tableName = var7_6;
        void var8_7 = connection2;
        this.connection = var8_7;
        void var9_8 = dialect2;
        this.dialect = var9_8;
        void var10_9 = lockPollIntervalMs;
        this.lockPollIntervalMs = var10_9;
        dialect2.createLocksTableIfNotExists((String)tableName, (Connection)connection2);
    }

    public JDBCPessimisticLocking(String tableName, Connection connection, long lockPollIntervalMs) {
        this(tableName, connection, lockPollIntervalMs, new BasicDialect());
    }

    public JDBCPessimisticLocking(String tableName, Connection connection) {
        this(tableName, connection, 10, new BasicDialect());
    }

    /*
     * Unable to fully structure code
     */
    public void tryLock(String key, long timeoutMs) throws LockWaitTimeoutException {
        lockStarted = System.currentTimeMillis();
        JDBCPessimisticLocking.LOGGER.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Trying to lock key '", "'"})));
        while (System.currentTimeMillis() - lockStarted < timeoutMs) {
            if (!this.dialect.isLockedByMe(this.tableName, key, this.connection)) ** GOTO lbl14
            JDBCPessimisticLocking.LOGGER.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"key '", "' is already locked by me"})));
            return;
lbl14:
            // 1 sources

            this.dialect.tryLock(this.tableName, key, this.connection);
            JDBCPessimisticLocking.LOGGER.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Successfully locked key '", "'"})));
            try {
                return;
            }
            catch (SQLException e) {
                JDBCPessimisticLocking.LOGGER.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Lock trial was unsuccessful for key ", ""})), (Throwable)e);
            }
            JDBCPessimisticLocking.LOGGER.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Still waiting for lock '", "'"})));
            DefaultGroovyStaticMethods.sleep(null, (long)this.lockPollIntervalMs);
        }
        throw (Throwable)new LockWaitTimeoutException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key, timeoutMs}, new String[]{"Failed to lock key '", "' within ", "ms"})));
    }

    public void unlock(String key) throws InvalidLockOwnerException {
        try {
            LOGGER.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Trying to unlock key ", ""})));
            this.dialect.tryUnlock(this.tableName, key, this.connection);
        }
        catch (SQLException e) {
            LOGGER.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Failed to unlock key ", ""})), (Throwable)e);
            throw (Throwable)new InvalidLockOwnerException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"Failed to unlock key '", "'"})), (Throwable)e);
        }
    }

    public boolean isLocked(String key) {
        return this.dialect.isLocked(this.tableName, key, this.connection);
    }

    public boolean isLockedByMe(String key) {
        return this.dialect.isLockedByMe(this.tableName, key, this.connection);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JDBCPessimisticLocking.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOGGER = logger = LoggerFactory.getLogger(JDBCPessimisticLocking.class);
    }

    public static final Logger getLOGGER() {
        return LOGGER;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final Dialect getDialect() {
        return this.dialect;
    }

    public final long getLockPollIntervalMs() {
        return this.lockPollIntervalMs;
    }
}

