/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.web.admin.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.scolastico.tools.etc.TableGenerator;
import me.scolastico.tools.etc.TableGeneratorThemes;
import me.scolastico.tools.web.admin.AdminPanelInstaller;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="ap-list-permissions", aliases={"listperm"}, version={"1.0.0"}, mixinStandardHelpOptions=true, description={"List the permissions of 's.Admin' (an) admin panel user(s)."})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lme/scolastico/tools/web/admin/commands/ListPermissionsCommand;", "Ljava/lang/Runnable;", "()V", "user", "", "getUser", "()Ljava/lang/String;", "setUser", "(Ljava/lang/String;)V", "run", "", "Companion", "tools"})
public final class ListPermissionsCommand
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Option(names={"-u", "--user"}, description={"Set an username to only show the permissions of an user."})
    @Nullable
    private String user;
    private static final int AUTO_LINE_BREAK_CHAR_COUNT = 100;

    @Nullable
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@Nullable String string) {
        this.user = string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        if (this.user != null) {
            String string = this.user;
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                ArrayList permissions2;
                HashMap<String, String> hashMap = AdminPanelInstaller.Companion.getCurrentConfig().getUser();
                String string2 = this.user;
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!hashMap.containsKey(string3)) {
                    Ansi permissions2 = AdminPanelInstaller.Companion.prefix().fgRed().a("This user does not exist!").fgDefault();
                    System.out.println(permissions2);
                    return;
                }
                ArrayList arrayList = (ArrayList)((Map)AdminPanelInstaller.Companion.getCurrentConfig().getPermissions()).get(this.user);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                if ((permissions2 = arrayList).size() > 0) {
                    Ansi ansi = AdminPanelInstaller.Companion.prefix().fgGreen().a("Found " + permissions2.size() + " permissions for the user '" + this.user + "': ").fgDefault();
                    Iterable iterable = permissions2;
                    String string4 = Ansi.ansi().fgYellow().a(", ").fgDefault().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ansi()\n                 \u2026\").fgDefault().toString()");
                    Ansi ansi2 = ansi.a(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, null, (int)62, null));
                    System.out.println(ansi2);
                    return;
                }
                Ansi ansi = AdminPanelInstaller.Companion.prefix().fgGreen().a("The user '" + this.user + "' has no permissions.").fgDefault();
                System.out.println(ansi);
                return;
            }
        }
        String[] stringArray = new String[]{Ansi.ansi().fgYellow().a("User").reset().toString(), Ansi.ansi().a("<!-- CENTER -->").fgYellow().a("Permission").reset().toString()};
        TableGenerator generator = TableGeneratorThemes.FANCY_BOARDER().setBoarderColorPrefix(Ansi.ansi().fgBright(Ansi.Color.BLACK).toString()).setBoarderColorSuffix(Ansi.ansi().fgDefault().toString()).setAutoLineBreak(100).addContent(stringArray).addTableLineSeparator();
        boolean firstLine = true;
        Iterator<String> iterator = AdminPanelInstaller.Companion.getCurrentConfig().getPermissions().keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                System.out.println(generator);
                return;
            }
            String user = iterator.next();
            if (!firstLine) {
                generator.addTableLineSeparator();
            }
            if (firstLine) {
                firstLine = false;
            }
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            ArrayList<String> arrayList = AdminPanelInstaller.Companion.getCurrentConfig().getPermissions().get(user);
            Intrinsics.checkNotNull(arrayList);
            stringArray2[1] = CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            generator.addContent(stringArray2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/scolastico/tools/web/admin/commands/ListPermissionsCommand$Companion;", "", "()V", "AUTO_LINE_BREAK_CHAR_COUNT", "", "tools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

