/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.web.admin.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.scolastico.tools.web.admin.AdminPanelInstaller;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="ap-delete-permission", aliases={"delperm"}, version={"1.0.0"}, mixinStandardHelpOptions=true, description={"Delete an permission of an 's.Admin' admin panel user."})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u000e"}, d2={"Lme/scolastico/tools/web/admin/commands/DeletePermissionCommand;", "Ljava/lang/Runnable;", "()V", "permission", "", "getPermission", "()Ljava/lang/String;", "setPermission", "(Ljava/lang/String;)V", "user", "getUser", "setUser", "run", "", "tools"})
public final class DeletePermissionCommand
implements Runnable {
    @CommandLine.Parameters(description={"The user where the permission will be added. (Case insensitive)"})
    @NotNull
    private String user = "";
    @CommandLine.Parameters(description={"The 'permission' or better known the command you want to allow to a user.", "You can use a '*' at the start/end to allow all command beginning/ending with the 'permission'."})
    @NotNull
    private String permission = "";

    @NotNull
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.user = string;
    }

    @NotNull
    public final String getPermission() {
        return this.permission;
    }

    public final void setPermission(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.permission = string;
    }

    @Override
    public void run() {
        HashMap<String, ArrayList<String>> hashMap = AdminPanelInstaller.Companion.getCurrentConfig().getPermissions();
        String string = this.user.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        ArrayList arrayList = hashMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        ArrayList permissions = arrayList;
        String string2 = this.permission.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (permissions.contains(string2)) {
            String string3 = this.permission.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            permissions.remove(string3);
            Map map = AdminPanelInstaller.Companion.getCurrentConfig().getPermissions();
            String string4 = this.user.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            map.put(string4, permissions);
            AdminPanelInstaller.Companion.saveConfig$default(AdminPanelInstaller.Companion, null, 1, null);
            Ansi ansi = AdminPanelInstaller.Companion.prefix().fgGreen().a("Removed permission '" + this.permission + "' from the user '" + this.user + "'.").fgDefault();
            System.out.println(ansi);
        } else {
            Ansi ansi = AdminPanelInstaller.Companion.prefix().fgRed().a("This user and/or permission does not exist!").fgDefault();
            System.out.println(ansi);
        }
    }
}

