/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.web.admin.commands;

import com.kosprov.jargon2.api.Jargon2;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.scolastico.tools.web.admin.AdminPanelInstaller;
import org.apache.commons.io.FileUtils;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="ap-adduser", aliases={"adduser"}, version={"1.0.0"}, mixinStandardHelpOptions=true, description={"Add an user to the 's.Admin' admin panel."})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u000f"}, d2={"Lme/scolastico/tools/web/admin/commands/CreateUserCommand;", "Ljava/lang/Runnable;", "()V", "password", "", "getPassword", "()Ljava/lang/String;", "setPassword", "(Ljava/lang/String;)V", "user", "getUser", "setUser", "run", "", "Companion", "tools"})
public final class CreateUserCommand
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Parameters(description={"The user name of the user which will be created. (Case insensitive)"})
    @NotNull
    private String user = "";
    @CommandLine.Parameters(description={"The password.", "If you dont want to enter it in the console because of the console log", "write the password into an file and add an file@ before the password string", "to load it from an file and to automatically delete that file afterwards."})
    @NotNull
    private String password = "";

    @NotNull
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.user = string;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    @Override
    public void run() {
        HashMap<String, String> hashMap = AdminPanelInstaller.Companion.getCurrentConfig().getUser();
        String string = this.user.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!hashMap.containsKey(string)) {
            Companion.createUser(this.user, this.password);
            Ansi ansi = AdminPanelInstaller.Companion.prefix().fgGreen().a("Created the user '" + this.user + "'.").fgDefault();
            System.out.println(ansi);
        } else {
            Ansi ansi = AdminPanelInstaller.Companion.prefix().fgRed().a("Sorry, the user '" + this.user + "' exists already.").fgDefault();
            System.out.println(ansi);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lme/scolastico/tools/web/admin/commands/CreateUserCommand$Companion;", "", "()V", "createUser", "", "user", "", "password", "tools"})
    public static final class Companion {
        private Companion() {
        }

        public final void createUser(@NotNull String user, @NotNull String password) {
            String string;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            String p = password;
            if (StringsKt.startsWith$default((String)password, (String)"file@", (boolean)false, (int)2, null)) {
                String string2 = password.substring("file@".length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                File file = new File(string2);
                if (!file.exists()) {
                    string = AdminPanelInstaller.Companion.prefix().fgRed().a("Sorry, this password file does not exist!").fgDefault();
                    System.out.println((Object)string);
                }
                String string3 = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readFileToString(file, StandardCharsets.UTF_8)");
                p = string3;
            }
            Jargon2.Hasher hasher = AdminPanelInstaller.Companion.getHasher();
            string = p;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String string4 = hasher.password(byArray).encodedHash();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"AdminPanelInstaller.hash\u2026yteArray()).encodedHash()");
            p = string4;
            Map map = AdminPanelInstaller.Companion.getCurrentConfig().getUser();
            String string5 = user.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            map.put(string5, p);
            AdminPanelInstaller.Companion.saveConfig$default(AdminPanelInstaller.Companion, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

