/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.web.admin.commands;

import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.scolastico.tools.web.admin.AdminPanelInstaller;
import me.scolastico.tools.web.admin.commands.CreateUserCommand;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="ap-passwd", aliases={"passwd"}, version={"1.0.0"}, mixinStandardHelpOptions=true, description={"Change the password of an 's.Admin' admin panel user."})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u000e"}, d2={"Lme/scolastico/tools/web/admin/commands/ChangePasswordCommand;", "Ljava/lang/Runnable;", "()V", "password", "", "getPassword", "()Ljava/lang/String;", "setPassword", "(Ljava/lang/String;)V", "user", "getUser", "setUser", "run", "", "tools"})
public final class ChangePasswordCommand
implements Runnable {
    @CommandLine.Parameters(description={"The user where to edit the password. (Case insensitive)"})
    @NotNull
    private String user = "";
    @CommandLine.Parameters(description={"The password.", "If you dont want to enter it in the console because of the console log", "write the password into an file and add an file@ before the password string", "to load it from an file and to automatically delete that file afterwards."})
    @NotNull
    private String password = "";

    @NotNull
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.user = string;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    @Override
    public void run() {
        HashMap<String, String> hashMap = AdminPanelInstaller.Companion.getCurrentConfig().getUser();
        String string = this.user.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (hashMap.containsKey(string)) {
            CreateUserCommand.Companion.createUser(this.user, this.password);
            HashMap<String, String> hashMap2 = AdminPanelInstaller.Companion.getTokens();
            String string2 = this.user.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            hashMap2.remove(string2);
            Ansi ansi = AdminPanelInstaller.Companion.prefix().fgGreen().a("Updated the password from the user '" + this.user + "'.").fgDefault();
            System.out.println(ansi);
        } else {
            Ansi ansi = AdminPanelInstaller.Companion.prefix().fgRed().a("Sorry, this user could not be found.").fgDefault();
            System.out.println(ansi);
        }
    }
}

