/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.web.admin;

import com.kosprov.jargon2.api.Jargon2;
import io.ktor.http.cio.websocket.CloseReason;
import io.ktor.http.cio.websocket.WebSocketSession;
import io.ktor.http.cio.websocket.WebSocketSessionKt;
import io.ktor.websocket.DefaultWebSocketServerSession;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import me.scolastico.tools.console.ConsoleManager;
import me.scolastico.tools.handler.ConfigHandler;
import me.scolastico.tools.web.WebserverManager;
import me.scolastico.tools.web.admin.commands.AddPermissionCommand;
import me.scolastico.tools.web.admin.commands.ChangePasswordCommand;
import me.scolastico.tools.web.admin.commands.CreateUserCommand;
import me.scolastico.tools.web.admin.commands.DeletePermissionCommand;
import me.scolastico.tools.web.admin.commands.DeleteUserCommand;
import me.scolastico.tools.web.admin.commands.ListPermissionsCommand;
import me.scolastico.tools.web.admin.commands.ListUserCommand;
import me.scolastico.tools.web.admin.etc.AdminPanelConfig;
import me.scolastico.tools.web.admin.etc.KtorGsonInstaller;
import me.scolastico.tools.web.admin.etc.KtorWebsocketInstaller;
import me.scolastico.tools.web.admin.etc.NewLogLineEventHandler;
import me.scolastico.tools.web.admin.web.AdminPanelAPI;
import me.scolastico.tools.web.admin.web.AdminPanelFrontend;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lme/scolastico/tools/web/admin/AdminPanelInstaller;", "", "()V", "Companion", "tools"})
public final class AdminPanelInstaller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long CLEANUP_SCHEDULER_SECONDS = 30L;
    @NotNull
    private static AdminPanelConfig currentConfig = new AdminPanelConfig(false, null, null, null, 15, null);
    @NotNull
    private static ConfigHandler<AdminPanelConfig> configHandler = new ConfigHandler<AdminPanelConfig>(currentConfig, "admin-config.json");
    @NotNull
    private static final HashMap<String, String> tokens = new HashMap();
    @NotNull
    private static final HashMap<String, Instant> tokenDate = new HashMap();
    @NotNull
    private static final Jargon2.Verifier verifier;
    private static boolean enabled;
    @NotNull
    private static final Jargon2.Hasher hasher;

    private AdminPanelInstaller() {
    }

    static {
        Jargon2.Verifier verifier = Jargon2.jargon2Verifier();
        Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"jargon2Verifier()");
        AdminPanelInstaller.verifier = verifier;
        Jargon2.Hasher hasher = Jargon2.jargon2Hasher().type(Jargon2.Type.ARGON2d).memoryCost(65536).timeCost(3).parallelism(4).saltLength(16).hashLength(16);
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"jargon2Hasher()\n        \u2026          .hashLength(16)");
        AdminPanelInstaller.hasher = hasher;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00122\b\b\u0002\u0010(\u001a\u00020\u0012J\u0006\u0010)\u001a\u00020$J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020$2\b\b\u0002\u0010-\u001a\u00020\u0007J\u0006\u0010.\u001a\u00020$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"Lme/scolastico/tools/web/admin/AdminPanelInstaller$Companion;", "", "()V", "CLEANUP_SCHEDULER_SECONDS", "", "configHandler", "Lme/scolastico/tools/handler/ConfigHandler;", "Lme/scolastico/tools/web/admin/etc/AdminPanelConfig;", "getConfigHandler", "()Lme/scolastico/tools/handler/ConfigHandler;", "setConfigHandler", "(Lme/scolastico/tools/handler/ConfigHandler;)V", "currentConfig", "getCurrentConfig", "()Lme/scolastico/tools/web/admin/etc/AdminPanelConfig;", "setCurrentConfig", "(Lme/scolastico/tools/web/admin/etc/AdminPanelConfig;)V", "enabled", "", "hasher", "Lcom/kosprov/jargon2/api/Jargon2$Hasher;", "getHasher", "()Lcom/kosprov/jargon2/api/Jargon2$Hasher;", "tokenDate", "Ljava/util/HashMap;", "", "Ljava/time/Instant;", "getTokenDate", "()Ljava/util/HashMap;", "tokens", "getTokens", "verifier", "Lcom/kosprov/jargon2/api/Jargon2$Verifier;", "getVerifier", "()Lcom/kosprov/jargon2/api/Jargon2$Verifier;", "install", "", "webserver", "Lme/scolastico/tools/web/WebserverManager;", "installWebsocketExtension", "installGSONExtension", "loadConfig", "prefix", "Lorg/fusesource/jansi/Ansi;", "saveConfig", "config", "startTimer", "tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AdminPanelConfig getCurrentConfig() {
            return currentConfig;
        }

        public final void setCurrentConfig(@NotNull AdminPanelConfig adminPanelConfig) {
            Intrinsics.checkNotNullParameter((Object)adminPanelConfig, (String)"<set-?>");
            currentConfig = adminPanelConfig;
        }

        @NotNull
        public final ConfigHandler<AdminPanelConfig> getConfigHandler() {
            return configHandler;
        }

        public final void setConfigHandler(@NotNull ConfigHandler<AdminPanelConfig> configHandler) {
            Intrinsics.checkNotNullParameter(configHandler, (String)"<set-?>");
            AdminPanelInstaller.configHandler = configHandler;
        }

        @NotNull
        public final HashMap<String, String> getTokens() {
            return tokens;
        }

        @NotNull
        public final HashMap<String, Instant> getTokenDate() {
            return tokenDate;
        }

        @NotNull
        public final Jargon2.Verifier getVerifier() {
            return verifier;
        }

        @NotNull
        public final Jargon2.Hasher getHasher() {
            return hasher;
        }

        public final void install(@NotNull WebserverManager webserver, boolean installWebsocketExtension, boolean installGSONExtension) {
            Intrinsics.checkNotNullParameter((Object)webserver, (String)"webserver");
            if (enabled) {
                return;
            }
            enabled = true;
            this.loadConfig();
            if (installWebsocketExtension) {
                webserver.registerModule(new KtorWebsocketInstaller());
            }
            if (installGSONExtension) {
                webserver.registerModule(new KtorGsonInstaller());
            }
            webserver.registerModule(new AdminPanelAPI());
            webserver.registerModule(new AdminPanelFrontend());
            ConsoleManager.registerCommand(new AddPermissionCommand());
            ConsoleManager.registerCommand(new ChangePasswordCommand());
            ConsoleManager.registerCommand(new CreateUserCommand());
            ConsoleManager.registerCommand(new DeletePermissionCommand());
            ConsoleManager.registerCommand(new DeleteUserCommand());
            ConsoleManager.registerCommand(new ListPermissionsCommand());
            ConsoleManager.registerCommand(new ListUserCommand());
            ConsoleManager.registerNewLogLineRoutine(new NewLogLineEventHandler());
            this.startTimer();
        }

        public static /* synthetic */ void install$default(Companion companion, WebserverManager webserverManager, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            companion.install(webserverManager, bl, bl2);
        }

        public final void loadConfig() {
            if (!this.getConfigHandler().checkIfExists()) {
                this.getConfigHandler().saveDefaultConfig();
            }
            AdminPanelConfig adminPanelConfig = this.getConfigHandler().loadConfig();
            Intrinsics.checkNotNullExpressionValue((Object)adminPanelConfig, (String)"configHandler.loadConfig()");
            this.setCurrentConfig(adminPanelConfig);
        }

        public final void saveConfig(@NotNull AdminPanelConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.setCurrentConfig(config);
            this.getConfigHandler().storeConfig(config);
        }

        public static /* synthetic */ void saveConfig$default(Companion companion, AdminPanelConfig adminPanelConfig, int n, Object object) {
            if ((n & 1) != 0) {
                adminPanelConfig = companion.getCurrentConfig();
            }
            companion.saveConfig(adminPanelConfig);
        }

        @NotNull
        public final Ansi prefix() {
            Ansi ansi = Ansi.ansi().fgBright(Ansi.Color.BLACK).a("[").fgBrightMagenta().a("s.Admin").fgBright(Ansi.Color.BLACK).a("] ");
            Intrinsics.checkNotNullExpressionValue((Object)ansi, (String)"ansi()\n                .\u2026Ansi.Color.BLACK).a(\"] \")");
            return ansi;
        }

        public final void startTimer() {
            new Timer("s-admin-panel-token-invalidator").scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    Object token;
                    TimerTask $this$startTimer_u24lambda_u2d0 = this;
                    boolean bl = false;
                    ArrayList<Object> toDeleteTokens = new ArrayList<Object>();
                    ArrayList<String> toDeleteUser = new ArrayList<String>();
                    for (Map.Entry<K, V> entry : ((Map)AdminPanelInstaller.Companion.getTokenDate()).entrySet()) {
                        token = (String)entry.getKey();
                        Instant instant = (Instant)entry.getValue();
                        if (!instant.plusMillis(TimeUnit.HOURS.toMillis(1L)).isBefore(Instant.now())) continue;
                        toDeleteTokens.add(token);
                    }
                    for (String string : toDeleteTokens) {
                        AdminPanelInstaller.Companion.getTokenDate().remove(string);
                        for (Map.Entry entry : ((Map)AdminPanelInstaller.Companion.getTokens()).entrySet()) {
                            String user = (String)entry.getKey();
                            String t = (String)entry.getValue();
                            if (!Intrinsics.areEqual((Object)string, (Object)t)) continue;
                            toDeleteUser.add(user);
                        }
                    }
                    for (String string : toDeleteUser) {
                        AdminPanelInstaller.Companion.getTokens().remove(string);
                        token = AdminPanelInstaller.Companion.prefix().fgYellow().a("The session of the user '" + string + "' timed out.").fgDefault();
                        System.out.println(token);
                        if (!AdminPanelAPI.Companion.getConnections().containsKey(string)) continue;
                        try {
                            DefaultWebSocketServerSession con;
                            Intrinsics.checkNotNull((Object)AdminPanelAPI.Companion.getConnections().get(string));
                            AdminPanelAPI.Companion.getConnections().remove(string);
                            new Thread(new Runnable(con){
                                final /* synthetic */ DefaultWebSocketServerSession $con;
                                {
                                    this.$con = $con;
                                }

                                public final void run() {
                                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$con, null){
                                        int label;
                                        final /* synthetic */ DefaultWebSocketServerSession $con;
                                        {
                                            this.$con = $con;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.label = 1;
                                                    Object object3 = WebSocketSessionKt.close((WebSocketSession)((WebSocketSession)this.$con), (CloseReason)new CloseReason(CloseReason.Codes.NORMAL, "timeout"), (Continuation)((Continuation)this));
                                                    if (object3 != object2) return Unit.INSTANCE;
                                                    return object2;
                                                }
                                                case 1: {
                                                    Object object3;
                                                    try {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                    catch (Throwable throwable) {
                                                        // empty catch block
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)1, null);
                                }
                            }).start();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }, TimeUnit.SECONDS.toMillis(30L), TimeUnit.SECONDS.toMillis(30L));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

