/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.web;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.config.ApplicationConfig;
import io.ktor.config.HoconApplicationConfig;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.EmbeddedServerKt;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.server.netty.Netty;
import io.ktor.server.netty.NettyApplicationEngine;
import java.io.File;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import me.scolastico.tools.web.WebserverRegistration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u00a7\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0010\u0012$\b\u0002\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0010\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0001J\u0006\u0010!\u001a\u00020\u0000J\u001a\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020$R6\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R6\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001aj\b\u0012\u0004\u0012\u00020\u0005`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lme/scolastico/tools/web/WebserverManager;", "", "listeningPort", "", "listeningHost", "", "sslPort", "sslKeyStoreFile", "Ljava/io/File;", "sslKeyStore", "Ljava/security/KeyStore;", "sslKeyAlias", "sslKeyPassword", "sslStorePassword", "ktorConfigObjects", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "applicationConfigObjects", "(ILjava/lang/String;Ljava/lang/Integer;Ljava/io/File;Ljava/security/KeyStore;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/HashMap;Ljava/util/HashMap;)V", "getApplicationConfigObjects", "()Ljava/util/HashMap;", "setApplicationConfigObjects", "(Ljava/util/HashMap;)V", "getKtorConfigObjects", "setKtorConfigObjects", "modules", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "server", "Lio/ktor/server/netty/NettyApplicationEngine;", "Ljava/lang/Integer;", "registerModule", "module", "start", "stop", "gracePeriodMillis", "", "timeoutMillis", "tools"})
public final class WebserverManager {
    private final int listeningPort;
    @NotNull
    private final String listeningHost;
    @Nullable
    private final Integer sslPort;
    @Nullable
    private final File sslKeyStoreFile;
    @Nullable
    private final KeyStore sslKeyStore;
    @NotNull
    private final String sslKeyAlias;
    @NotNull
    private final String sslKeyPassword;
    @NotNull
    private final String sslStorePassword;
    @NotNull
    private HashMap<String, Object> ktorConfigObjects;
    @NotNull
    private HashMap<String, Object> applicationConfigObjects;
    @NotNull
    private final ArrayList<String> modules;
    @Nullable
    private NettyApplicationEngine server;

    public WebserverManager(int listeningPort, @NotNull String listeningHost, @Nullable Integer sslPort, @Nullable File sslKeyStoreFile, @Nullable KeyStore sslKeyStore, @NotNull String sslKeyAlias, @NotNull String sslKeyPassword, @NotNull String sslStorePassword, @NotNull HashMap<String, Object> ktorConfigObjects, @NotNull HashMap<String, Object> applicationConfigObjects) {
        Intrinsics.checkNotNullParameter((Object)listeningHost, (String)"listeningHost");
        Intrinsics.checkNotNullParameter((Object)sslKeyAlias, (String)"sslKeyAlias");
        Intrinsics.checkNotNullParameter((Object)sslKeyPassword, (String)"sslKeyPassword");
        Intrinsics.checkNotNullParameter((Object)sslStorePassword, (String)"sslStorePassword");
        Intrinsics.checkNotNullParameter(ktorConfigObjects, (String)"ktorConfigObjects");
        Intrinsics.checkNotNullParameter(applicationConfigObjects, (String)"applicationConfigObjects");
        this.listeningPort = listeningPort;
        this.listeningHost = listeningHost;
        this.sslPort = sslPort;
        this.sslKeyStoreFile = sslKeyStoreFile;
        this.sslKeyStore = sslKeyStore;
        this.sslKeyAlias = sslKeyAlias;
        this.sslKeyPassword = sslKeyPassword;
        this.sslStorePassword = sslStorePassword;
        this.ktorConfigObjects = ktorConfigObjects;
        this.applicationConfigObjects = applicationConfigObjects;
        this.modules = new ArrayList();
    }

    public /* synthetic */ WebserverManager(int n, String string, Integer n2, File file, KeyStore keyStore, String string2, String string3, String string4, HashMap hashMap, HashMap hashMap2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 8080;
        }
        if ((n3 & 2) != 0) {
            string = "127.0.0.1";
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            file = null;
        }
        if ((n3 & 0x10) != 0) {
            keyStore = null;
        }
        if ((n3 & 0x20) != 0) {
            string2 = "ssl";
        }
        if ((n3 & 0x40) != 0) {
            string3 = "password";
        }
        if ((n3 & 0x80) != 0) {
            string4 = "password";
        }
        if ((n3 & 0x100) != 0) {
            hashMap = new HashMap<String, Object>();
        }
        if ((n3 & 0x200) != 0) {
            hashMap2 = new HashMap<String, Object>();
        }
        this(n, string, n2, file, keyStore, string2, string3, string4, hashMap, hashMap2);
    }

    @NotNull
    public final HashMap<String, Object> getKtorConfigObjects() {
        return this.ktorConfigObjects;
    }

    public final void setKtorConfigObjects(@NotNull HashMap<String, Object> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.ktorConfigObjects = hashMap;
    }

    @NotNull
    public final HashMap<String, Object> getApplicationConfigObjects() {
        return this.applicationConfigObjects;
    }

    public final void setApplicationConfigObjects(@NotNull HashMap<String, Object> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.applicationConfigObjects = hashMap;
    }

    @NotNull
    public final WebserverManager start() {
        if (this.server == null) {
            boolean sslEnabled = this.sslKeyStore != null && this.sslPort != null && this.sslKeyStoreFile != null;
            Map map = this.applicationConfigObjects;
            String string = "modules";
            ConfigList configList = ConfigValueFactory.fromIterable((Iterable)CollectionsKt.toList((Iterable)this.modules));
            Intrinsics.checkNotNullExpressionValue((Object)configList, (String)"fromIterable(modules.toList())");
            ConfigList configList2 = configList;
            map.put(string, configList2);
            map = this.ktorConfigObjects;
            string = "application";
            ConfigObject configObject = ConfigValueFactory.fromMap((Map)this.applicationConfigObjects);
            Intrinsics.checkNotNullExpressionValue((Object)configObject, (String)"fromMap(applicationConfigObjects)");
            configList2 = configObject;
            map.put(string, configList2);
            Config c = ConfigFactory.load().withValue("ktor", (ConfigValue)ConfigValueFactory.fromMap((Map)this.ktorConfigObjects));
            this.server = ((NettyApplicationEngine)EmbeddedServerKt.embeddedServer$default((ApplicationEngineFactory)((ApplicationEngineFactory)Netty.INSTANCE), (ApplicationEngineEnvironment)ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(c, sslEnabled, this){
                final /* synthetic */ Config $c;
                final /* synthetic */ boolean $sslEnabled;
                final /* synthetic */ WebserverManager this$0;
                {
                    this.$c = $c;
                    this.$sslEnabled = $sslEnabled;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                    Function0 $this$invoke_u24lambda_u2d0;
                    List list;
                    EngineConnectorBuilder engineConnectorBuilder;
                    Object object;
                    block5: {
                        void $this$connector$iv;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)$this$applicationEngineEnvironment, (String)"$this$applicationEngineEnvironment");
                            Config config = this.$c;
                            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"c");
                            $this$applicationEngineEnvironment.setConfig((ApplicationConfig)new HoconApplicationConfig(config));
                            Logger logger = LoggerFactory.getLogger((String)"ktor.application");
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"ktor.application\")");
                            $this$applicationEngineEnvironment.setLog(logger);
                            if (!this.$sslEnabled) break block4;
                            Integer n = WebserverManager.access$getSslPort$p(this.this$0);
                            int n2 = WebserverManager.access$getListeningPort$p(this.this$0);
                            if (n != null && n == n2) break block5;
                        }
                        ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$applicationEngineEnvironment;
                        object = this.this$0;
                        boolean $i$f$connector = false;
                        EngineConnectorBuilder engineConnectorBuilder2 = engineConnectorBuilder = new EngineConnectorBuilder(null, 1, null);
                        list = $this$connector$iv.getConnectors();
                        boolean bl = false;
                        $this$invoke_u24lambda_u2d0.setPort(WebserverManager.access$getListeningPort$p((WebserverManager)object));
                        $this$invoke_u24lambda_u2d0.setHost(WebserverManager.access$getListeningHost$p((WebserverManager)object));
                        list.add(engineConnectorBuilder);
                    }
                    if (this.$sslEnabled) {
                        void $this$invoke_u24lambda_u2d1;
                        void $this$sslConnector$iv;
                        void privateKeyPassword$iv;
                        void keyStorePassword$iv;
                        void keyAlias$iv;
                        void keyStore$iv;
                        EngineSSLConnectorBuilder engineSSLConnectorBuilder;
                        ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
                        KeyStore keyStore = WebserverManager.access$getSslKeyStore$p(this.this$0);
                        Intrinsics.checkNotNull((Object)keyStore);
                        object = keyStore;
                        String $i$f$connector = WebserverManager.access$getSslKeyAlias$p(this.this$0);
                        engineConnectorBuilder = (Function0)new Function0<char[]>(this.this$0){
                            final /* synthetic */ WebserverManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final char[] invoke() {
                                char[] cArray = WebserverManager.access$getSslStorePassword$p(this.this$0).toCharArray();
                                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                        };
                        $this$invoke_u24lambda_u2d0 = (Function0)new Function0<char[]>(this.this$0){
                            final /* synthetic */ WebserverManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final char[] invoke() {
                                char[] cArray = WebserverManager.access$getSslKeyPassword$p(this.this$0).toCharArray();
                                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                        };
                        WebserverManager webserverManager = this.this$0;
                        boolean $i$f$sslConnector = false;
                        EngineSSLConnectorBuilder engineSSLConnectorBuilder2 = engineSSLConnectorBuilder = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, (String)keyAlias$iv, (Function0)keyStorePassword$iv, (Function0)privateKeyPassword$iv);
                        list = $this$sslConnector$iv.getConnectors();
                        boolean bl = false;
                        Integer n = WebserverManager.access$getSslPort$p(webserverManager);
                        Intrinsics.checkNotNull((Object)n);
                        $this$invoke_u24lambda_u2d1.setPort(n.intValue());
                        $this$invoke_u24lambda_u2d1.setKeyStorePath(WebserverManager.access$getSslKeyStoreFile$p(webserverManager));
                        $this$invoke_u24lambda_u2d1.setHost(WebserverManager.access$getListeningHost$p(webserverManager));
                        list.add(engineSSLConnectorBuilder);
                    }
                }
            })), null, (int)4, null)).start(false);
        }
        return this;
    }

    @NotNull
    public final WebserverManager stop(long gracePeriodMillis, long timeoutMillis) {
        if (this.server != null) {
            NettyApplicationEngine nettyApplicationEngine = this.server;
            Intrinsics.checkNotNull((Object)nettyApplicationEngine);
            nettyApplicationEngine.stop(gracePeriodMillis, timeoutMillis);
            this.server = null;
        }
        return this;
    }

    public static /* synthetic */ WebserverManager stop$default(WebserverManager webserverManager, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1000L;
        }
        if ((n & 2) != 0) {
            l2 = 5000L;
        }
        return webserverManager.stop(l, l2);
    }

    @NotNull
    public final WebserverManager registerModule(@NotNull Object module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        for (KFunction function : KClasses.getDeclaredFunctions((KClass)Reflection.getOrCreateKotlinClass(module.getClass()))) {
            Object v0;
            block2: {
                KAnnotatedElement $this$hasAnnotation$iv = (KAnnotatedElement)function;
                boolean $i$f$hasAnnotation = false;
                KAnnotatedElement $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                    Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                    boolean bl = false;
                    if (!(it$iv$iv instanceof WebserverRegistration)) continue;
                    v0 = element$iv$iv$iv;
                    break block2;
                }
                v0 = null;
            }
            boolean bl = (Annotation)v0 != null;
            if (!bl) continue;
            this.modules.add(module.getClass().getName() + '.' + function.getName());
        }
        return this;
    }

    public WebserverManager() {
        this(0, null, null, null, null, null, null, null, null, null, 1023, null);
    }

    public static final /* synthetic */ Integer access$getSslPort$p(WebserverManager $this) {
        return $this.sslPort;
    }

    public static final /* synthetic */ int access$getListeningPort$p(WebserverManager $this) {
        return $this.listeningPort;
    }

    public static final /* synthetic */ KeyStore access$getSslKeyStore$p(WebserverManager $this) {
        return $this.sslKeyStore;
    }

    public static final /* synthetic */ String access$getSslKeyAlias$p(WebserverManager $this) {
        return $this.sslKeyAlias;
    }

    public static final /* synthetic */ String access$getSslStorePassword$p(WebserverManager $this) {
        return $this.sslStorePassword;
    }

    public static final /* synthetic */ String access$getSslKeyPassword$p(WebserverManager $this) {
        return $this.sslKeyPassword;
    }

    public static final /* synthetic */ String access$getListeningHost$p(WebserverManager $this) {
        return $this.listeningHost;
    }

    public static final /* synthetic */ File access$getSslKeyStoreFile$p(WebserverManager $this) {
        return $this.sslKeyStoreFile;
    }
}

