/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.routine;

import java.util.HashMap;
import java.util.List;
import me.scolastico.tools.handler.ErrorHandler;
import me.scolastico.tools.routine.Routine;
import me.scolastico.tools.routine.RoutineAnswer;

public class RoutineManager {
    private final List<Routine> routineList;
    private Routine canceledRoutine = null;
    private boolean running = false;
    private boolean started = false;
    private boolean canceled = false;
    private Thread thread = null;
    private String errorMessage = null;
    private Class<?> lastExecutedClass = null;
    private HashMap<String, Object> lastObjectMap = null;

    public RoutineManager(List<Routine> routineList) {
        this.routineList = routineList;
    }

    public RoutineManager(List<Routine> routineList, Routine canceledRoutine) {
        this.routineList = routineList;
        this.canceledRoutine = canceledRoutine;
    }

    private synchronized void execute(HashMap<String, Object> objectMap) {
        block7: {
            this.running = true;
            this.canceled = false;
            try {
                Routine[] skippedRoutine = null;
                for (Routine routine : this.routineList) {
                    if (skippedRoutine != null) {
                        boolean tmp = false;
                        for (void var9_11 : skippedRoutine) {
                            if (!routine.getClass().equals(var9_11.getClass())) continue;
                            tmp = true;
                            break;
                        }
                        if (tmp) continue;
                    }
                    this.lastExecutedClass = routine.getClass();
                    RoutineAnswer answer = routine.execute(objectMap);
                    if (answer.isStop()) {
                        this.errorMessage = answer.getErrorMessage();
                        this.canceled = true;
                        if (this.canceledRoutine != null) {
                            this.lastExecutedClass = this.canceledRoutine.getClass();
                            this.canceledRoutine.execute(objectMap);
                        }
                        break;
                    }
                    this.lastObjectMap = answer.getObjectMap();
                    objectMap = answer.getObjectMap();
                    skippedRoutine = answer.getSkippedRoutine();
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) break block7;
                ErrorHandler.handle(e);
                this.canceled = true;
            }
        }
        this.running = false;
    }

    public void start() {
        this.start(new HashMap<String, Object>());
    }

    public void start(final HashMap<String, Object> objectMap) {
        if (!this.running) {
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    RoutineManager.this.startNotAsynchronously(objectMap);
                }
            });
            this.thread.start();
        }
    }

    public void startNotAsynchronously() {
        this.startNotAsynchronously(new HashMap<String, Object>());
    }

    public void startNotAsynchronously(HashMap<String, Object> objectMap) {
        if (!this.running) {
            this.started = true;
            this.execute(objectMap);
        }
    }

    public void stop() {
        if (this.running) {
            this.thread.interrupt();
            this.canceled = true;
            this.running = false;
        }
    }

    public HashMap<String, Object> getLastObjectMap() {
        return this.lastObjectMap;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Class<?> getLastExecutedClass() {
        return this.lastExecutedClass;
    }
}

