/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.etc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TableGenerator {
    public static final String CENTER_ALIGNMENT = "<!-- CENTER -->";
    public static final String RIGHT_ALIGNMENT = "<!-- RIGHT -->";
    private final ArrayList<ArrayList<String>> content = new ArrayList();
    private Character borderVertical = Character.valueOf('|');
    private Character borderHorizontal = Character.valueOf('-');
    private Character borderInterceptionTop = Character.valueOf('-');
    private Character borderInterceptionBottom = Character.valueOf('-');
    private Character borderInterceptionLeft = Character.valueOf('|');
    private Character borderInterceptionMiddle = Character.valueOf('|');
    private Character borderInterceptionRight = Character.valueOf('|');
    private Character borderCornerTopLeft = Character.valueOf('-');
    private Character borderCornerTopRight = Character.valueOf('-');
    private Character borderCornerBottomLeft = Character.valueOf('-');
    private Character borderCornerBottomRight = Character.valueOf('-');
    private String boarderColorPrefix = "";
    private String boarderColorSuffix = "";
    private int borderSpace = 1;
    private Character space = Character.valueOf(' ');
    private int autoLineBreak = 0;
    private boolean header = true;
    private boolean footer = true;
    private boolean leftWall = true;
    private boolean rightWall = true;

    public TableGenerator addContent(String ... content) {
        this.content.add(new ArrayList<String>(List.of(content)));
        return this;
    }

    public TableGenerator addEmptyLine() {
        this.content.add(new ArrayList());
        return this;
    }

    public TableGenerator addTableLineSeparator() {
        this.content.add(new ArrayList<String>(List.of("<!-- NEW LINE -->")));
        return this;
    }

    public String toString() {
        return this.generate();
    }

    /*
     * WARNING - void declaration
     */
    public String generate() {
        StringBuilder builder = new StringBuilder();
        HashMap<Integer, Integer> length = new HashMap<Integer, Integer>();
        ArrayList brokenContent = new ArrayList();
        for (List list : this.content) {
            void var6_8;
            HashMap hashMap = new HashMap();
            int lines = 1;
            for (int i = 0; i < list.size(); ++i) {
                ArrayList<Object> newLines = var6_8.getOrDefault(i, new ArrayList());
                String s = (String)list.get(i);
                if (s.equals("<!-- NEW LINE -->")) {
                    HashMap<Integer, 1> hashMap2 = new HashMap<Integer, 1>();
                    hashMap2.put(0, new ArrayList<String>(){
                        {
                            this.add("<!-- NEW LINE -->");
                        }
                    });
                    continue;
                }
                int l = s.length();
                if (s.startsWith(CENTER_ALIGNMENT)) {
                    l -= CENTER_ALIGNMENT.length();
                }
                if (s.startsWith(RIGHT_ALIGNMENT)) {
                    l -= RIGHT_ALIGNMENT.length();
                }
                if (this.autoLineBreak > 0 && l > this.autoLineBreak) {
                    boolean center = s.startsWith(CENTER_ALIGNMENT);
                    boolean right = s.startsWith(RIGHT_ALIGNMENT);
                    s = s.replaceAll(CENTER_ALIGNMENT, "").replaceAll(RIGHT_ALIGNMENT, "");
                    for (String string : s.split("\r\n|\r|\n")) {
                        void var17_36;
                        while (var17_36.length() > this.autoLineBreak) {
                            int location = 0;
                            for (char ch : var17_36.substring(this.autoLineBreak - 10, this.autoLineBreak).toCharArray()) {
                                if (ch == ' ') break;
                                ++location;
                            }
                            location = this.autoLineBreak - 10 + location;
                            Object newLine = var17_36.substring(0, location);
                            this.getLineLengthWithoutSpecialStrings(length, i, s, (String)newLine);
                            newLine = (center ? CENTER_ALIGNMENT : "") + (right ? RIGHT_ALIGNMENT : "") + (String)newLine;
                            String string2 = var17_36.substring(location);
                            if (((String)newLine).startsWith(" ")) {
                                newLine = ((String)newLine).substring(1);
                            }
                            newLines.add(newLine);
                            var6_8.put(i, newLines);
                            if (lines >= newLines.size()) continue;
                            lines = newLines.size();
                        }
                        if (var17_36.isEmpty()) continue;
                        String string3 = (center ? CENTER_ALIGNMENT : "") + (right ? RIGHT_ALIGNMENT : "") + (String)(var17_36.startsWith(" ") ? var17_36.substring(1) : var17_36);
                        newLines.add(string3);
                        if (lines >= newLines.size()) continue;
                        lines = newLines.size();
                    }
                } else {
                    for (String line : s.split("\r\n|\r|\n")) {
                        this.getLineLengthWithoutSpecialStrings(length, i, s, line);
                        if (lines < newLines.size()) {
                            lines = newLines.size();
                        }
                        newLines.add(line);
                    }
                }
                var6_8.put(i, newLines);
            }
            for (int l = 0; l < lines; ++l) {
                ArrayList<String> brokenLine = new ArrayList<String>();
                for (int i = 0; i < var6_8.size(); ++i) {
                    ArrayList brokenLines = (ArrayList)var6_8.get(i);
                    if (brokenLines.size() > l) {
                        brokenLine.add((String)brokenLines.get(l));
                        continue;
                    }
                    brokenLine.add("");
                }
                brokenContent.add(brokenLine);
            }
        }
        if (this.header) {
            this.addSeparator(builder, length, this.borderCornerTopLeft, this.borderInterceptionTop, this.borderCornerTopRight);
        }
        String space = StringUtils.repeat((char)this.space.charValue(), (int)this.borderSpace);
        for (ArrayList arrayList : brokenContent) {
            while (arrayList.size() < length.size()) {
                arrayList.add("");
            }
            if (((String)arrayList.get(0)).equals("<!-- NEW LINE -->")) {
                this.addSeparator(builder, length, this.borderInterceptionLeft, this.borderInterceptionMiddle, this.borderInterceptionRight);
                continue;
            }
            if (this.leftWall) {
                builder.append(this.boarderColorPrefix).append(this.borderVertical).append(this.boarderColorSuffix);
            } else {
                builder.append(" ");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String s = (String)arrayList.get(i);
                boolean center = s.startsWith(CENTER_ALIGNMENT);
                boolean right = s.startsWith(RIGHT_ALIGNMENT);
                s = s.replaceAll(CENTER_ALIGNMENT, "").replaceAll(RIGHT_ALIGNMENT, "");
                String extraSpaces = StringUtils.repeat((char)this.space.charValue(), (int)((Integer)length.get(i) - s.replaceAll("(\\x9B|\\x1B\\[)[0-?]*[ -/]*[@-~]", "").length()));
                builder.append(space).append(center ? extraSpaces.substring(0, extraSpaces.length() / 2) : (right ? extraSpaces : "")).append(s).append(center ? extraSpaces.substring(extraSpaces.length() / 2) : (right ? "" : extraSpaces)).append(space);
                if (i >= arrayList.size() - 1) continue;
                builder.append(this.boarderColorPrefix).append(this.borderVertical).append(this.boarderColorSuffix);
            }
            if (this.rightWall) {
                builder.append(this.boarderColorPrefix).append(this.borderVertical).append(this.boarderColorSuffix);
            } else {
                builder.append(" ");
            }
            builder.append(System.lineSeparator());
        }
        if (this.footer) {
            this.addSeparator(builder, length, this.borderCornerBottomLeft, this.borderInterceptionBottom, this.borderCornerBottomRight);
        }
        String string = builder.toString();
        return string.substring(0, string.length() - System.lineSeparator().length());
    }

    private void getLineLengthWithoutSpecialStrings(Map<Integer, Integer> length, int i, String s, String newLine) {
        int l = newLine.replaceAll("(\\x9B|\\x1B\\[)[0-?]*[ -/]*[@-~]", "").length();
        if (s.startsWith(CENTER_ALIGNMENT)) {
            l -= CENTER_ALIGNMENT.length();
        }
        if (s.startsWith(RIGHT_ALIGNMENT)) {
            l -= RIGHT_ALIGNMENT.length();
        }
        if (l > length.getOrDefault(i, 0)) {
            length.put(i, l);
        }
    }

    private void addSeparator(StringBuilder builder, Map<Integer, Integer> length, Character cornerLeft, Character interception, Character cornerRight) {
        builder.append(this.boarderColorPrefix).append(cornerLeft);
        for (int i = 0; i < length.size(); ++i) {
            builder.append(StringUtils.repeat((char)this.borderHorizontal.charValue(), (int)(length.get(i) + this.borderSpace * 2)));
            if (i >= length.size() - 1) continue;
            builder.append(interception);
        }
        builder.append(cornerRight).append(this.boarderColorSuffix).append(System.lineSeparator());
    }

    public Character getBorderVertical() {
        return this.borderVertical;
    }

    public TableGenerator setBorderVertical(Character borderVertical) {
        this.borderVertical = borderVertical;
        return this;
    }

    public Character getBorderHorizontal() {
        return this.borderHorizontal;
    }

    public TableGenerator setBorderHorizontal(Character borderHorizontal) {
        this.borderHorizontal = borderHorizontal;
        return this;
    }

    public Character getBorderInterceptionTop() {
        return this.borderInterceptionTop;
    }

    public TableGenerator setBorderInterceptionTop(Character borderInterceptionTop) {
        this.borderInterceptionTop = borderInterceptionTop;
        return this;
    }

    public Character getBorderInterceptionBottom() {
        return this.borderInterceptionBottom;
    }

    public TableGenerator setBorderInterceptionBottom(Character borderInterceptionBottom) {
        this.borderInterceptionBottom = borderInterceptionBottom;
        return this;
    }

    public Character getBorderInterceptionLeft() {
        return this.borderInterceptionLeft;
    }

    public TableGenerator setBorderInterceptionLeft(Character borderInterceptionLeft) {
        this.borderInterceptionLeft = borderInterceptionLeft;
        return this;
    }

    public Character getBorderInterceptionMiddle() {
        return this.borderInterceptionMiddle;
    }

    public TableGenerator setBorderInterceptionMiddle(Character borderInterceptionMiddle) {
        this.borderInterceptionMiddle = borderInterceptionMiddle;
        return this;
    }

    public Character getBorderInterceptionRight() {
        return this.borderInterceptionRight;
    }

    public TableGenerator setBorderInterceptionRight(Character borderInterceptionRight) {
        this.borderInterceptionRight = borderInterceptionRight;
        return this;
    }

    public Character getBorderCornerTopLeft() {
        return this.borderCornerTopLeft;
    }

    public TableGenerator setBorderCornerTopLeft(Character borderCornerTopLeft) {
        this.borderCornerTopLeft = borderCornerTopLeft;
        return this;
    }

    public Character getBorderCornerTopRight() {
        return this.borderCornerTopRight;
    }

    public TableGenerator setBorderCornerTopRight(Character borderCornerTopRight) {
        this.borderCornerTopRight = borderCornerTopRight;
        return this;
    }

    public Character getBorderCornerBottomLeft() {
        return this.borderCornerBottomLeft;
    }

    public TableGenerator setBorderCornerBottomLeft(Character borderCornerBottomLeft) {
        this.borderCornerBottomLeft = borderCornerBottomLeft;
        return this;
    }

    public Character getBorderCornerBottomRight() {
        return this.borderCornerBottomRight;
    }

    public TableGenerator setBorderCornerBottomRight(Character borderCornerBottomRight) {
        this.borderCornerBottomRight = borderCornerBottomRight;
        return this;
    }

    public int getBorderSpace() {
        return this.borderSpace;
    }

    public TableGenerator setBorderSpace(int borderSpace) {
        this.borderSpace = borderSpace;
        return this;
    }

    public Character getSpace() {
        return this.space;
    }

    public TableGenerator setSpace(Character space) {
        this.space = space;
        return this;
    }

    public String getBoarderColorPrefix() {
        return this.boarderColorPrefix;
    }

    public TableGenerator setBoarderColorPrefix(String boarderColorPrefix) {
        this.boarderColorPrefix = boarderColorPrefix;
        return this;
    }

    public String getBoarderColorSuffix() {
        return this.boarderColorSuffix;
    }

    public TableGenerator setBoarderColorSuffix(String boarderColorSuffix) {
        this.boarderColorSuffix = boarderColorSuffix;
        return this;
    }

    public int getAutoLineBreak() {
        return this.autoLineBreak;
    }

    public TableGenerator setAutoLineBreak(int autoLineBreak) {
        this.autoLineBreak = autoLineBreak;
        return this;
    }

    public boolean isHeader() {
        return this.header;
    }

    public TableGenerator setHeader(boolean header) {
        this.header = header;
        return this;
    }

    public boolean isFooter() {
        return this.footer;
    }

    public TableGenerator setFooter(boolean footer) {
        this.footer = footer;
        return this;
    }

    public boolean isLeftWall() {
        return this.leftWall;
    }

    public TableGenerator setLeftWall(boolean leftWall) {
        this.leftWall = leftWall;
        return this;
    }

    public boolean isRightWall() {
        return this.rightWall;
    }

    public TableGenerator setRightWall(boolean rightWall) {
        this.rightWall = rightWall;
        return this;
    }
}

