/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.dataholder;

import me.scolastico.tools.handler.SchedulerHandler;

public class SchedulerConfiguration {
    private final long executeEveryTick;
    private final boolean runOnce;
    private final Runnable runnable;
    private final boolean async;
    private long lastExecute = 0L;

    public SchedulerConfiguration(long executeEveryTick, Runnable runnable) {
        this.executeEveryTick = executeEveryTick;
        this.runOnce = false;
        this.runnable = runnable;
        this.async = true;
    }

    public SchedulerConfiguration(long executeEveryTick, boolean runOnce, Runnable runnable) {
        this.executeEveryTick = executeEveryTick;
        this.runOnce = runOnce;
        this.runnable = runnable;
        this.async = true;
    }

    public SchedulerConfiguration(long executeEveryTick, boolean runOnce, Runnable runnable, boolean async) {
        this.executeEveryTick = executeEveryTick;
        this.runOnce = runOnce;
        this.runnable = runnable;
        this.async = async;
    }

    public void executeTick(Long id) {
        if (this.lastExecute >= this.executeEveryTick) {
            this.lastExecute = 0L;
            if (this.async) {
                Thread thread = new Thread(this.runnable);
                thread.start();
            } else {
                this.runnable.run();
            }
            if (this.runOnce) {
                SchedulerHandler.removeConfiguration(id);
            }
        }
        ++this.lastExecute;
    }
}

