/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.console.commands;

import java.util.function.Consumer;
import me.scolastico.tools.console.ConsoleManager;
import me.scolastico.tools.etc.TableGenerator;
import me.scolastico.tools.etc.TableGeneratorThemes;
import org.fusesource.jansi.Ansi;
import picocli.CommandLine;

@CommandLine.Command(name="help", description={"List all available commands."}, mixinStandardHelpOptions=true, helpCommand=true, version={"1.0.0"})
public class HelpCommand
implements Runnable,
Consumer<Object> {
    private static final String BG_BLACK = Ansi.ansi().bgBright(Ansi.Color.BLACK).fgBlack().toString();
    private static final String BG_DEFAULT = Ansi.ansi().bgDefault().toString();
    private static final String FG_CYAN = Ansi.ansi().fgBrightCyan().toString();
    private static final String FG_MAGENTA = Ansi.ansi().fgMagenta().toString();
    private static final String FG_GRAY = Ansi.ansi().fgBrightBlack().toString();
    private static final String FG_DEFAULT = Ansi.ansi().fgDefault().toString();

    @Override
    public void run() {
        TableGenerator generator = TableGeneratorThemes.FANCY_BOARDER().setRightWall(false).setLeftWall(false).setFooter(false).setHeader(false).setBorderInterceptionLeft(Character.valueOf(' ')).setBorderInterceptionRight(Character.valueOf(' ')).setBorderInterceptionMiddle(Character.valueOf('+')).setBorderVertical(Character.valueOf(' ')).setBoarderColorPrefix(FG_GRAY).setBoarderColorSuffix(FG_DEFAULT).setAutoLineBreak(100).addContent(Ansi.ansi().fgYellow().a("Command").reset().toString(), Ansi.ansi().a("<!-- CENTER -->").fgYellow().a("Description").reset().toString(), Ansi.ansi().a("<!-- CENTER -->").fgYellow().a("Aliases").reset().toString()).addTableLineSeparator();
        int maxLineLength = ConsoleManager.getTerminal().getSize().getColumns();
        if (maxLineLength > 0 && maxLineLength < 100) {
            generator.setAutoLineBreak(60);
        }
        boolean bg = false;
        for (Object o : ConsoleManager.getCommands()) {
            CommandLine.Command annotation = o.getClass().getAnnotation(CommandLine.Command.class);
            generator.addContent((bg ? BG_BLACK : "") + FG_CYAN + annotation.name() + FG_DEFAULT, String.join((CharSequence)System.lineSeparator(), annotation.description()), "<!-- RIGHT -->" + FG_MAGENTA + String.join((CharSequence)(FG_DEFAULT + ", " + FG_MAGENTA), annotation.aliases()) + FG_DEFAULT + (bg ? BG_DEFAULT : ""));
            bg = !bg;
        }
        System.out.println();
        System.out.println(generator);
        System.out.println();
    }

    public static String[] generateHelpPage(Object command) {
        return new String[]{"help page"};
    }

    @Override
    public void accept(Object o) {
        System.out.println(String.join((CharSequence)System.lineSeparator(), HelpCommand.generateHelpPage(o)));
    }
}

