/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.console;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.scolastico.tools.console.commands.ClearScreenCommand;
import me.scolastico.tools.console.commands.ExitCommand;
import me.scolastico.tools.console.commands.HeadCommand;
import me.scolastico.tools.console.commands.HelpCommand;
import me.scolastico.tools.console.commands.StatusCommand;
import me.scolastico.tools.etc.StackTraceRedirectionPrintStream;
import me.scolastico.tools.handler.ErrorHandler;
import me.scolastico.tools.routine.Routine;
import me.scolastico.tools.routine.RoutineManager;
import org.fusesource.jansi.Ansi;
import org.jline.console.CommandRegistry;
import org.jline.console.SystemRegistry;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.widget.TailTipWidgets;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

public class ConsoleManager {
    private static String INPUT_PREFIX = Ansi.ansi().fgGreen().a("prompt> ").reset().toString();
    private static int MAX_TAB_COMPLETE_SIZE = 50;
    private static Callable<String> OUTPUT_PREFIX = null;
    private static boolean OUTPUT_PREFIX_TIME = true;
    private static SystemRegistry SYSTEM_REGISTRY = null;
    private static CommandLine COMMAND_LINE = null;
    private static Terminal TERMINAL = null;
    private static final List<String> CONSOLE_LOG_LINES = new ArrayList<String>();
    private static Integer MAX_CONSOLE_LOG_LINES = 4096;
    private static boolean ENABLED = false;
    private static LineReader READER = null;
    private static Consumer<Object> HELP_PAGE_RENDERER = new HelpCommand();
    private static final ArrayList<Routine> NEW_LOG_LINE_ROUTINES = new ArrayList();
    private static final List<Object> COMMANDS = new ArrayList<Object>(){
        {
            this.add(HELP_PAGE_RENDERER);
            this.add(new ExitCommand());
            this.add(new ClearScreenCommand());
            this.add(new StatusCommand());
        }
    };

    public static synchronized void enable() throws IOException {
        if (!ENABLED) {
            Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
            HeadCommand commands = new HeadCommand();
            PicocliCommands.PicocliCommandsFactory factory = new PicocliCommands.PicocliCommandsFactory();
            COMMAND_LINE = new CommandLine((Object)commands, (CommandLine.IFactory)factory);
            PicocliCommands picocliCommands = new PicocliCommands(COMMAND_LINE);
            DefaultParser parser = new DefaultParser();
            TERMINAL = TerminalBuilder.builder().build();
            SYSTEM_REGISTRY = new SystemRegistryImpl((Parser)parser, TERMINAL, workDir, null);
            SYSTEM_REGISTRY.setCommandRegistries(new CommandRegistry[]{picocliCommands});
            READER = LineReaderBuilder.builder().terminal(TERMINAL).completer(SYSTEM_REGISTRY.completer()).parser((Parser)parser).variable("list-max", (Object)MAX_TAB_COMPLETE_SIZE).build();
            factory.setTerminal(TERMINAL);
            TailTipWidgets widgets = new TailTipWidgets(READER, arg_0 -> ((SystemRegistry)SYSTEM_REGISTRY).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
            widgets.enable();
            KeyMap keyMap = (KeyMap)READER.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
            for (Object o : COMMANDS) {
                COMMAND_LINE.addSubcommand(o);
            }
            PipedOutputStream outOut = new PipedOutputStream();
            PipedInputStream outIn = new PipedInputStream(outOut, 65536);
            PrintStream newOutOut = new PrintStream(outOut);
            final Scanner outScanner = new Scanner(outIn);
            StackTraceRedirectionPrintStream inStream = new StackTraceRedirectionPrintStream(newOutOut, System.out, "org.jline.reader.LineReader");
            PipedOutputStream errOut = new PipedOutputStream();
            PipedInputStream errIn = new PipedInputStream(errOut, 65536);
            PrintStream newErrOut = new PrintStream(errOut);
            final Scanner errScanner = new Scanner(errIn);
            StackTraceRedirectionPrintStream errStream = new StackTraceRedirectionPrintStream(newErrOut, System.err, "org.jline.reader.LineReader");
            System.setOut(inStream);
            System.setErr(errStream);
            new Timer().scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        String nextLine;
                        while (outScanner.hasNextLine()) {
                            nextLine = outScanner.nextLine();
                            ConsoleManager.print(nextLine, READER);
                        }
                        while (errScanner.hasNextLine()) {
                            nextLine = errScanner.nextLine();
                            ConsoleManager.print(nextLine, READER);
                        }
                    }
                    catch (Exception e) {
                        ErrorHandler.enableErrorLogFile();
                        ErrorHandler.handle(e);
                    }
                }
            }, 5L, 5L);
            new Thread(() -> {
                block6: while (true) {
                    String command = "";
                    try {
                        SYSTEM_REGISTRY.cleanUp();
                        command = READER.readLine(INPUT_PREFIX, null, (MaskingCallback)null, null);
                        if (command.equalsIgnoreCase("HELP") || command.toUpperCase().startsWith("HELP ") || command.equalsIgnoreCase("EXIT") || command.toUpperCase().startsWith("EXIT ")) {
                            COMMAND_LINE.execute(command.split(" "));
                            continue;
                        }
                        SYSTEM_REGISTRY.execute(command);
                        continue;
                    }
                    catch (UserInterruptException userInterruptException) {
                        continue;
                    }
                    catch (IllegalArgumentException | CommandLine.UnmatchedArgumentException e) {
                        Object c = null;
                        for (Object o : COMMANDS) {
                            String cmd = command.split(" ")[0];
                            CommandLine.Command annotation = o.getClass().getAnnotation(CommandLine.Command.class);
                            if (annotation.name().equalsIgnoreCase(cmd)) {
                                c = o;
                                break;
                            }
                            for (String alias : annotation.aliases()) {
                                if (!alias.equalsIgnoreCase(cmd)) continue;
                                c = o;
                                break;
                            }
                            if (c == null) continue;
                            break;
                        }
                        if (c == null) {
                            ErrorHandler.handle(new InvalidClassException("An IllegalArgumentException could not find its help page for the command '" + command + "'."));
                            continue;
                        }
                        String[] stringArray = HelpCommand.generateHelpPage(c);
                        int n = stringArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block6;
                            String line = stringArray[n2];
                            ConsoleManager.print(line, READER);
                            ++n2;
                        }
                    }
                    catch (SystemRegistryImpl.UnknownCommandException e) {
                        ConsoleManager.print(Ansi.ansi().fgRed().a("Command '").fgBrightRed().a(command).fgRed().a("' not found.").reset().toString(), READER);
                        continue;
                    }
                    catch (EndOfFileException e) {
                        System.exit(1);
                        return;
                    }
                    catch (Exception e) {
                        ErrorHandler.handleFatal(e);
                        continue;
                    }
                    break;
                }
            }).start();
            ENABLED = true;
        }
    }

    public static void runCommand(String command) throws Exception {
        if (SYSTEM_REGISTRY != null) {
            if (command.equalsIgnoreCase("HELP") || command.toUpperCase().startsWith("HELP ") || command.equalsIgnoreCase("EXIT") || command.toUpperCase().startsWith("EXIT ")) {
                COMMAND_LINE.execute(command.split(" "));
            }
        } else {
            throw new IllegalAccessException("Cant be accessed before ConsoleManager is enabled!");
        }
        SYSTEM_REGISTRY.execute(command);
    }

    public static void registerCommand(Object command) {
        if (COMMAND_LINE != null) {
            COMMAND_LINE.addSubcommand(command);
        }
        COMMANDS.add(command);
    }

    public static void registerNewLogLineRoutine(Routine routine) {
        NEW_LOG_LINE_ROUTINES.add(routine);
    }

    private static void print(String line, LineReader reader) {
        Object prefix = "";
        if (OUTPUT_PREFIX_TIME) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            prefix = (String)prefix + Ansi.ansi().a("[").fgCyan().a(dtf.format(now)).reset().a("] ");
        }
        if (OUTPUT_PREFIX != null) {
            try {
                prefix = (String)prefix + OUTPUT_PREFIX.call() + " ";
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        }
        ConsoleManager.addLineToLog((String)prefix + line);
        reader.printAbove((String)prefix + line);
    }

    private static void addLineToLog(String line) {
        if (NEW_LOG_LINE_ROUTINES.size() > 0) {
            RoutineManager manager = new RoutineManager(NEW_LOG_LINE_ROUTINES);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("LINE", line);
            map.put("line", line);
            map.put("Line", line);
            manager.startNotAsynchronously(map);
        }
        CONSOLE_LOG_LINES.add(line);
        if (CONSOLE_LOG_LINES.size() > MAX_CONSOLE_LOG_LINES) {
            CONSOLE_LOG_LINES.remove(0);
        }
    }

    public static Consumer<Object> getHelpPageRenderer() {
        return HELP_PAGE_RENDERER;
    }

    public static void setHelpPageRenderer(Consumer<Object> helpPageRenderer) {
        HELP_PAGE_RENDERER = helpPageRenderer;
    }

    public static Object[] getCommands() {
        return COMMANDS.toArray(new Object[0]);
    }

    public static String getInputPrefix() {
        return INPUT_PREFIX;
    }

    public static void setInputPrefix(String inputPrefix) {
        INPUT_PREFIX = inputPrefix;
    }

    public static int getMaxTabCompleteSize() {
        return MAX_TAB_COMPLETE_SIZE;
    }

    public static void setMaxTabCompleteSize(int maxTabCompleteSize) {
        MAX_TAB_COMPLETE_SIZE = maxTabCompleteSize;
    }

    public static Callable<String> getOutputPrefix() {
        return OUTPUT_PREFIX;
    }

    public static void setOutputPrefix(Callable<String> outputPrefix) {
        OUTPUT_PREFIX = outputPrefix;
    }

    public static boolean isOutputPrefixTime() {
        return OUTPUT_PREFIX_TIME;
    }

    public static void setOutputPrefixTime(boolean outputPrefixTime) {
        OUTPUT_PREFIX_TIME = outputPrefixTime;
    }

    public static LineReader getReader() {
        return READER;
    }

    public static Integer getMaxConsoleLogLines() {
        return MAX_CONSOLE_LOG_LINES;
    }

    public static void setMaxConsoleLogLines(Integer maxConsoleLogLines) {
        MAX_CONSOLE_LOG_LINES = maxConsoleLogLines;
    }

    public static Terminal getTerminal() {
        return TERMINAL;
    }

    public static String[] getLastLogLines() {
        return CONSOLE_LOG_LINES.toArray(new String[0]);
    }

    public static boolean isEnabled() {
        return ENABLED;
    }
}

