/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.simplified.rsa;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import me.scolastico.tools.etc.StringSplitter;

public class RSAConverter {
    private static boolean firstRun = true;

    public static String publicToPEM(PublicKey publicKey) {
        StringBuilder ret = new StringBuilder("-----BEGIN PUBLIC KEY-----\n");
        for (String line : StringSplitter.Companion.splitStringByLength(Base64.getEncoder().encodeToString(publicKey.getEncoded()), 64)) {
            ret.append(line).append("\n");
        }
        ret.append("-----END PUBLIC KEY-----");
        return ret.toString();
    }

    public static String privateToPEM(PrivateKey privateKey) {
        StringBuilder ret = new StringBuilder("-----BEGIN RSA PRIVATE KEY-----\n");
        for (String line : StringSplitter.Companion.splitStringByLength(Base64.getEncoder().encodeToString(privateKey.getEncoded()), 64)) {
            ret.append(line).append("\n");
        }
        ret.append("-----END RSA PRIVATE KEY-----");
        return ret.toString();
    }

    public static byte[] pemToBytes(String pem) {
        pem = pem.replace("\r", "").replace("\n", "");
        pem = pem.replaceAll("-----BEGIN RSA PRIVATE KEY-----", "");
        pem = pem.replaceAll("-----END RSA PRIVATE KEY-----", "");
        pem = pem.replaceAll("-----BEGIN PUBLIC KEY-----", "");
        pem = pem.replaceAll("-----END PUBLIC KEY-----", "");
        return Base64.getDecoder().decode(pem);
    }

    public static PublicKey bytesToPublicKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(bytes));
    }

    public static PrivateKey bytesToPrivateKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(bytes));
    }

    public static KeyPair privateKeyToKeyPair(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPrivateCrtKey privateKeyCrt = (RSAPrivateCrtKey)privateKey;
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privateKeyCrt.getModulus(), privateKeyCrt.getPublicExponent());
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(publicKeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    public static byte[] getBytes(PrivateKey key) {
        return key.getEncoded();
    }

    public static byte[] getBytes(PublicKey key) {
        return key.getEncoded();
    }
}

