/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.simplified;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class SimplifiedResourceFileReader {
    private static SimplifiedResourceFileReader instance = null;

    public static SimplifiedResourceFileReader getInstance() {
        if (instance == null) {
            instance = new SimplifiedResourceFileReader();
        }
        return instance;
    }

    private SimplifiedResourceFileReader() {
    }

    public byte[] getByteArrayFromResources(String path) throws IOException, NullPointerException {
        return this.getResourceAsStream(path).readAllBytes();
    }

    public String getStringFromResources(String path) {
        try {
            return IOUtils.toString((InputStream)this.getResourceAsStream(path), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException exception) {
            return null;
        }
    }

    public String[] getAllResourcesInFolder(String path) {
        Reflections reflections = new Reflections(path, new Scanner[]{new ResourcesScanner()});
        Set resourceList = reflections.getResources(x -> true);
        return resourceList.toArray(new String[0]);
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        return in == null ? this.getClass().getResourceAsStream(resource) : in;
    }
}

