/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.handler;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javassist.NotFoundException;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateHandler {
    public static String getNewestVersion(String ghRepo) throws IOException {
        JSONObject json = new JSONObject(UpdateHandler.getReleaseData(ghRepo));
        return json.getString("tag_name");
    }

    public static void installUpdate(String ghRepo, String assetName, Class<?> mainClass) throws IOException, NotFoundException {
        JSONObject json = new JSONObject(UpdateHandler.getReleaseData(ghRepo));
        JSONArray assets = json.getJSONArray("assets");
        for (int i = 0; i < assets.length(); ++i) {
            int bytesRead;
            JSONObject asset = assets.getJSONObject(i);
            if (!asset.getString("name").equals(assetName)) continue;
            BufferedInputStream in = new BufferedInputStream(new URL(asset.getString("url")).openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(mainClass.getProtectionDomain().getCodeSource().getLocation().getFile());
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            return;
        }
        throw new NotFoundException("No asset with the name '" + assetName + "' was found in the latest release.");
    }

    private static String getReleaseData(String ghRepo) throws IOException {
        String inputLine;
        HttpsURLConnection con = (HttpsURLConnection)new URL("https://api.github.com/repos/" + ghRepo + "/releases/latest").openConnection();
        con.setRequestMethod("GET");
        con.setConnectTimeout(1000);
        con.setReadTimeout(1000);
        int status = con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        con.disconnect();
        return content.toString();
    }
}

