/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.handler;

import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public class ErrorHandler
implements Thread.UncaughtExceptionHandler {
    private static boolean sentry = false;
    private static File errorLog = null;
    private static boolean createdNewLog = false;

    public static void enableSentry(String sentryDns) {
        ErrorHandler.enableSentry(sentryDns, null, null);
    }

    public static void enableSentry(String sentryDns, Double tracesSampleRate, String release) {
        if (!sentry) {
            Sentry.init(options -> {
                options.setDsn(sentryDns);
                if (tracesSampleRate != null) {
                    options.setTracesSampleRate(tracesSampleRate);
                }
                if (release != null) {
                    options.setRelease(release);
                }
            });
            sentry = true;
        }
    }

    public static void enableCatchUncaughtException() {
        Thread.setDefaultUncaughtExceptionHandler(new ErrorHandler());
    }

    public static void enableErrorLogFile() {
        try {
            errorLog = new File("error.log");
            if (errorLog.exists()) {
                int counter = 2;
                File destination = new File("error." + counter + ".log");
                while (destination.exists()) {
                    destination = new File("error." + ++counter + ".log");
                }
                FileUtils.moveFile((File)errorLog, (File)destination);
            }
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    public static void handle(Throwable e) {
        ErrorHandler.handle(e, SentryLevel.ERROR, new String[0]);
    }

    public static void handle(Throwable e, SentryLevel level, String ... debugInformation) {
        if (sentry) {
            SentryEvent event = new SentryEvent();
            event.setLevel(level);
            event.setThrowable(e);
            int i = 1;
            for (String info : debugInformation) {
                event.setExtra("Debug Information [" + i + "]", (Object)info);
                ++i;
            }
            Sentry.captureEvent((SentryEvent)event);
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String exceptionAsString = stringWriter.toString();
        System.err.println("Message: " + e.getMessage());
        System.err.println("StackTrace:");
        System.err.println(exceptionAsString);
        if (errorLog != null) {
            try {
                if (!createdNewLog) {
                    createdNewLog = true;
                    FileUtils.writeStringToFile((File)errorLog, (String)("Error log created at (UNIX) " + System.currentTimeMillis() / 1000L + "\n\n"), (Charset)StandardCharsets.UTF_8, (boolean)false);
                }
                FileUtils.writeStringToFile((File)errorLog, (String)("Time (UNIX): " + System.currentTimeMillis() / 1000L + "\nMessage: " + e.getMessage() + "\nStack Trace:\n" + exceptionAsString + "\n\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (IOException exception) {
                System.err.println("WARNING: Can't write stacktrace to the 'error.log' file!");
            }
        }
    }

    public static void handleFatal(Throwable e) {
        ErrorHandler.handleFatal(e, 1);
    }

    public static void handleFatal(Throwable e, int exitCode) {
        ErrorHandler.handle(e);
        System.out.println();
        System.out.println("FATAL ERROR SHUTTING DOWN!");
        System.out.println();
        System.exit(exitCode);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        ErrorHandler.handleFatal(e);
    }
}

