/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class ConfigHandler<Config> {
    private static final Gson gson = new GsonBuilder().serializeNulls().disableHtmlEscaping().setPrettyPrinting().create();
    private final String path;
    private final File file;
    private final Config defaultConfig;

    public ConfigHandler(Config defaultConfig, String path) throws IOException {
        this.defaultConfig = defaultConfig;
        this.path = path;
        this.file = new File(path);
        if (this.file.exists()) {
            if (!this.file.canRead()) {
                throw new IOException("Cannot read file '" + path + "'!");
            }
            if (!this.file.canWrite()) {
                throw new IOException("Cannot write file '" + path + "'!");
            }
        }
    }

    public ConfigHandler(Config defaultConfig, String path, Boolean writeDefaultConfigAutomatically) throws IOException {
        this.defaultConfig = defaultConfig;
        this.path = path;
        this.file = new File(path);
        if (this.file.exists()) {
            if (!this.file.canRead()) {
                throw new IOException("Cannot read file '" + path + "'!");
            }
            if (!this.file.canWrite()) {
                throw new IOException("Cannot write file '" + path + "'!");
            }
        }
        if (writeDefaultConfigAutomatically.booleanValue()) {
            if (this.file.exists()) {
                this.saveDefaultConfig();
            } else {
                this.storeConfig(this.loadConfig());
            }
        }
    }

    public boolean checkIfExists() {
        return this.file.exists();
    }

    public boolean delete() {
        return this.file.delete() || !this.checkIfExists();
    }

    public void saveDefaultConfig() throws IOException {
        FileUtils.writeStringToFile((File)this.file, (String)gson.toJson(this.defaultConfig), (Charset)StandardCharsets.UTF_8);
    }

    public Config loadConfig() throws IOException {
        return (Config)gson.fromJson(FileUtils.readFileToString((File)this.file, (Charset)StandardCharsets.UTF_8), this.defaultConfig.getClass());
    }

    public void storeConfig(Config config) throws IOException {
        FileUtils.writeStringToFile((File)this.file, (String)gson.toJson(config), (Charset)StandardCharsets.UTF_8);
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public Config getDefaultConfig() {
        return this.defaultConfig;
    }

    public static String getUserConfigFolder() {
        return ConfigHandler.getUserConfigFolder(null);
    }

    public static String getUserConfigFolder(String projectName) {
        Object path = SystemUtils.IS_OS_WINDOWS ? System.getenv("APPDATA") + "\\" + projectName + "\\" : (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX ? SystemUtils.getUserHome().getAbsolutePath() + "/.config/" + projectName + "/" : "./.config/");
        File file = new File((String)path);
        file.mkdirs();
        return path;
    }

    public static String getSystemConfigFolder(String projectName) {
        Object path = SystemUtils.IS_OS_WINDOWS ? System.getenv("ProgramData") + "\\" + projectName + "\\" : (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX ? "/etc/" + projectName + "/config/" : "./SYSTEM-WIDE-CONFIG-FOLDER-NOT-SUPPORTED/");
        File file = new File((String)path);
        file.mkdirs();
        return path;
    }
}

