/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.etc;

import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;

public class StackTraceRedirectionPrintStream
extends PrintStream {
    private final PrintStream normalPrintStream;
    private final PrintStream redirectedPrintStream;
    private final String lookForClassName;

    public StackTraceRedirectionPrintStream(@NotNull PrintStream normalPrintStream, @NotNull PrintStream redirectedPrintStream, @NotNull String lookForClassName) {
        super(normalPrintStream);
        this.normalPrintStream = normalPrintStream;
        this.redirectedPrintStream = redirectedPrintStream;
        this.lookForClassName = lookForClassName;
    }

    @Override
    public boolean checkError() {
        if (this.shouldBeRedirected()) {
            return this.redirectedPrintStream.checkError();
        }
        return this.normalPrintStream.checkError();
    }

    @Override
    public void write(@NotNull byte[] buf, int off, int len) {
        if (this.shouldBeRedirected()) {
            this.redirectedPrintStream.write(buf, off, len);
        } else {
            this.normalPrintStream.write(buf, off, len);
        }
    }

    @Override
    public void write(int b) {
        if (this.shouldBeRedirected()) {
            this.redirectedPrintStream.write(b);
        } else {
            this.normalPrintStream.write(b);
        }
    }

    @Override
    public void flush() {
        if (this.shouldBeRedirected()) {
            this.redirectedPrintStream.flush();
        } else {
            this.normalPrintStream.flush();
        }
    }

    @Override
    public void close() {
        if (this.shouldBeRedirected()) {
            this.redirectedPrintStream.close();
        } else {
            this.normalPrintStream.close();
        }
    }

    private boolean shouldBeRedirected() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals(this.lookForClassName)) continue;
            return true;
        }
        return false;
    }
}

