/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.ebean;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import io.ebean.Database;
import io.ebean.DatabaseFactory;
import io.ebean.annotation.TxIsolation;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationRunner;
import java.sql.SQLException;
import me.scolastico.tools.ebean.DataBaseType;
import me.scolastico.tools.ebean.DatabaseConfig;
import org.slf4j.LoggerFactory;

public class DatabaseConnector {
    private Database database = null;
    private final DataSourceConfig dataSourceConfig = new DataSourceConfig();
    private final MigrationConfig migrationConfig = new MigrationConfig();
    private final io.ebean.config.DatabaseConfig dbConfig = new io.ebean.config.DatabaseConfig();
    private DatabaseConfig config = null;
    private boolean started = false;
    private boolean debug = false;
    private boolean migrated = false;
    private final boolean defaultServer;

    public DatabaseConnector(boolean defaultServer) {
        this.defaultServer = defaultServer;
    }

    public DatabaseConnector() {
        this.defaultServer = false;
    }

    public static void loadDatabaseDrivers() throws ClassNotFoundException {
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        Class.forName("com.mysql.cj.jdbc.Driver");
        Class.forName("org.mariadb.jdbc.Driver");
        Class.forName("org.sqlite.JDBC");
        Class.forName("org.postgresql.Driver");
        Class.forName("oracle.jdbc.driver.OracleDriver");
    }

    public synchronized void connectToDatabase(DatabaseConfig config) {
        if (!this.started) {
            if (config.getDatabaseType() == DataBaseType.H2) {
                System.err.println("H2 Database is disabled because of CVE-2022-23221, CVE-2021-42392 and CVE-2021-23463.");
                System.err.println("To get more information about that visit: https://github.com/scolastico-dev/s.Tools/issues/98");
                return;
            }
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            Logger ebeanLogger = loggerContext.getLogger("io.ebean");
            Logger reflectionsLogger = loggerContext.getLogger("org.reflections");
            this.debug = config.isDebug();
            if (this.debug) {
                ebeanLogger.setLevel(Level.DEBUG);
                reflectionsLogger.setLevel(Level.DEBUG);
            } else {
                ebeanLogger.setLevel(Level.WARN);
                reflectionsLogger.setLevel(Level.WARN);
            }
            this.config = config;
            this.dataSourceConfig.setUsername(config.getUsername());
            this.dataSourceConfig.setPassword(config.getPassword());
            this.migrationConfig.setMigrationPath("dbmigration/" + config.getDatabaseType().name);
            switch (config.getDatabaseType().name) {
                case "sql17": {
                    this.dataSourceConfig.setDriver("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                    this.dataSourceConfig.setUrl("jdbc:sqlserver://" + config.getHost() + ":" + config.getPort() + ";databaseName=" + config.getDatabase());
                    break;
                }
                case "mysql": {
                    this.dataSourceConfig.setDriver("com.mysql.cj.jdbc.Driver");
                    this.dataSourceConfig.setUrl("jdbc:mysql://" + config.getHost() + ":" + config.getPort() + "/" + config.getDatabase());
                    break;
                }
                case "mariadb": {
                    this.dataSourceConfig.setDriver("org.mariadb.jdbc.Driver");
                    this.dataSourceConfig.setUrl("jdbc:mariadb://" + config.getHost() + ":" + config.getPort() + "/" + config.getDatabase() + "?useLegacyDatetimeCode=false");
                    break;
                }
                case "sqlite": {
                    this.dataSourceConfig.setDriver("org.sqlite.JDBC");
                    this.dataSourceConfig.setUrl("jdbc:sqlite:" + config.getHost());
                    this.dataSourceConfig.setIsolationLevel(TxIsolation.READ_UNCOMMITTED.getLevel());
                    break;
                }
                case "postgres": {
                    this.dataSourceConfig.setDriver("org.postgresql.Driver");
                    this.dataSourceConfig.setUrl("jdbc:postgresql://" + config.getHost() + ":" + config.getPort() + "/" + config.getDatabase());
                    break;
                }
                case "oracle": {
                    this.dataSourceConfig.setDriver("oracle.jdbc.driver.OracleDriver");
                    this.dataSourceConfig.setUsername(config.getDatabase());
                    this.dataSourceConfig.setUrl("jdbc:oracle:thin:@" + config.getHost() + ":" + config.getPort() + ":XE");
                    break;
                }
                case "h2": {
                    this.dataSourceConfig.setDriver("org.h2.Driver");
                    this.dataSourceConfig.setUrl("jdbc:h2:" + config.getHost());
                }
            }
            this.dbConfig.setDataSourceConfig(this.dataSourceConfig);
            this.dbConfig.setName(config.getDatabase());
            this.dbConfig.setDefaultServer(this.defaultServer);
            this.database = DatabaseFactory.create((io.ebean.config.DatabaseConfig)this.dbConfig);
            this.started = true;
        }
    }

    public synchronized void runMigrations() throws SQLException {
        if (!this.migrated) {
            MigrationRunner migrationRunner = new MigrationRunner(this.migrationConfig);
            migrationRunner.run(this.database.dataSource().getConnection());
            this.migrated = true;
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public MigrationConfig getMigrationConfig() {
        return this.migrationConfig;
    }

    public io.ebean.config.DatabaseConfig getDbConfig() {
        return this.dbConfig;
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isMigrated() {
        return this.migrated;
    }
}

