/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.console.commands;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.NumberFormat;
import java.util.Date;
import me.scolastico.tools.console.ConsoleManager;
import me.scolastico.tools.etc.TableGenerator;
import me.scolastico.tools.etc.TableGeneratorThemes;
import org.apache.commons.lang3.ArrayUtils;
import org.fusesource.jansi.Ansi;
import picocli.CommandLine;

@CommandLine.Command(name="status", aliases={"top", "sysload"}, description={"Get the current status of the application with its usage of the system resources."}, mixinStandardHelpOptions=true, version={"1.0.0"})
public class StatusCommand
implements Runnable {
    @Override
    public void run() {
        boolean limitedLength;
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        System.out.println();
        System.out.println(TableGeneratorThemes.FANCY_BOARDER_GRAY().setBorderSpace(2).addContent("<!-- CENTER -->Memory Statistics").addTableLineSeparator().addContent(Ansi.ansi().a("<!-- CENTER -->").fgMagenta().a("Max memory:").fgDefault().toString(), Ansi.ansi().a("<!-- CENTER -->").fgRed().a("Allocated memory:").fgDefault().toString(), Ansi.ansi().a("<!-- CENTER -->").fgYellow().a("Free memory:").fgDefault().toString(), Ansi.ansi().a("<!-- CENTER -->").fgGreen().a("Total free memory:").fgDefault().toString()).addContent("<!-- CENTER -->" + format.format(maxMemory / 1024L) + "/kb", "<!-- CENTER -->" + format.format(allocatedMemory / 1024L) + "/kb", "<!-- CENTER -->" + format.format(freeMemory / 1024L) + "/kb", "<!-- CENTER -->" + format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L) + "/kb"));
        TableGenerator generator = TableGeneratorThemes.FANCY_BOARDER_GRAY().addContent("ID", "Name", "<!-- CENTER -->State", "Origin").addTableLineSeparator();
        int maxLineLength = ConsoleManager.getTerminal().getSize().getColumns();
        boolean bl = limitedLength = maxLineLength > 0 && maxLineLength < 100;
        if (limitedLength) {
            generator.addEmptyLine().setAutoLineBreak(30);
        }
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            String state;
            Object[] stackTraceElements = Thread.getAllStackTraces().get(thread);
            ArrayUtils.reverse((Object[])stackTraceElements);
            String origin = "";
            for (Object element : stackTraceElements) {
                if (origin.equals("")) {
                    origin = ((StackTraceElement)element).getClassName();
                }
                if (((StackTraceElement)element).getClassName().startsWith("java")) continue;
                origin = ((StackTraceElement)element).getClassName();
                break;
            }
            state = (state = thread.getState().toString()).contains("WAITING") ? Ansi.ansi().fgYellow().a(state).fgDefault().toString() : (state.contains("RUNNABLE") ? Ansi.ansi().fgGreen().a(state).fgDefault().toString() : Ansi.ansi().fgRed().a(state).fgDefault().toString());
            generator.addContent(Long.toString(thread.getId()), thread.getName(), "<!-- CENTER -->" + state, origin);
            if (!limitedLength) continue;
            generator.addEmptyLine();
        }
        System.out.println(generator);
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        long startTime = bean.getStartTime();
        long running = (System.currentTimeMillis() - startTime) / 1000L;
        long hours = running / 3600L;
        long minutes = running % 3600L / 60L;
        long seconds = running % 60L;
        System.out.println(TableGeneratorThemes.FANCY_BOARDER_GRAY().addContent("JVM Starting Time:", Ansi.ansi().fgMagenta().a(new Date(startTime).toString()).fgDefault().toString()).addContent("JVM Running Time:", Ansi.ansi().fgGreen().a(hours).a(":").a(minutes).a(":").a(seconds).fgDefault().toString()));
        System.out.println();
    }
}

