/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.console;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.TimeoutException;
import me.scolastico.tools.console.ConsoleManager;
import org.fusesource.jansi.AnsiConsole;

public class ConsoleLoadingAnimation {
    private static boolean enabled = false;
    private static Thread thread = null;
    private static char[] animation = new char[]{'/', '-', '\\', '|'};
    private static int step = 0;
    private static int speed = 25;
    private static PrintStream defaultStream;
    private static boolean takenOverOutputStream;

    public static void enable() {
        ConsoleLoadingAnimation.enable(true);
    }

    public static synchronized void enable(boolean takeOverSystemOutputStream) {
        if (!enabled && !ConsoleManager.isEnabled()) {
            defaultStream = System.out;
            takenOverOutputStream = takeOverSystemOutputStream;
            if (takeOverSystemOutputStream) {
                System.setOut(new PrintStream(new ByteArrayOutputStream()));
            }
            if (!AnsiConsole.isInstalled()) {
                AnsiConsole.systemInstall();
            }
            enabled = true;
            thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int currentSpeedStep = 0;
                    if (System.out != null) {
                        defaultStream.print(animation[0]);
                    }
                    while (enabled) {
                        try {
                            if (currentSpeedStep >= speed) {
                                currentSpeedStep = 0;
                                defaultStream.print('\b');
                                defaultStream.print(animation[step]);
                                if (++step >= animation.length) {
                                    step = 0;
                                }
                            }
                            Thread.sleep(10L);
                            ++currentSpeedStep;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static synchronized void disable() throws InterruptedException, TimeoutException {
        if (enabled) {
            enabled = false;
            if (takenOverOutputStream) {
                System.setOut(defaultStream);
            }
            int timeOut = 0;
            while (thread != null && thread.isAlive()) {
                Thread.sleep(50L);
                if (++timeOut < 200) continue;
                throw new TimeoutException("The output and input threads are still running and not shutting down.");
            }
            defaultStream.print('\b');
        }
    }

    public static void setAnimation(char[] animation) {
        ConsoleLoadingAnimation.animation = animation;
        step = 0;
    }

    public static void setSpeed(int speed) {
        ConsoleLoadingAnimation.speed = speed;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    static {
        takenOverOutputStream = false;
    }
}

