/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.tools.cache;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import me.scolastico.tools.cache.CacheData;
import me.scolastico.tools.cache.CacheObject;
import me.scolastico.tools.cache.CacheTypes;
import me.scolastico.tools.handler.ConfigHandler;
import me.scolastico.tools.handler.ErrorHandler;
import me.scolastico.tools.simplified.PBGson;
import org.apache.commons.io.FileUtils;

public class CacheManager {
    private static CacheData cacheData = null;
    private static ConfigHandler<CacheData> configHandler = null;

    public static void destroy() {
        try {
            File folder = new File(".cache");
            for (File file : folder.listFiles()) {
                if (file.isDirectory()) continue;
                file.delete();
            }
            cacheData = new CacheData();
            configHandler.saveDefaultConfig();
        }
        catch (Exception e) {
            ErrorHandler.handleFatal(e);
        }
    }

    public static synchronized void destroy(String id) {
        try {
            CacheData cacheData = CacheManager.getCacheData();
            String uuid = cacheData.getIds().get(id);
            cacheData.delId(id);
            cacheData.delObject(uuid);
            File file = new File(".cache/" + uuid);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleFatal(e);
        }
    }

    public static void destroyOld() {
        CacheData cacheData = CacheManager.getCacheData();
        ArrayList<String> uuids = new ArrayList<String>();
        for (String uuid : cacheData.getObjects().keySet()) {
            CacheObject object = cacheData.getObjects().get(uuid);
            if (!object.getValidUntil().isBefore(Instant.now())) continue;
            uuids.add(uuid);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : cacheData.getIds().keySet()) {
            if (!uuids.contains(cacheData.getIds().get(id))) continue;
            ids.add(id);
        }
        for (String id : ids) {
            CacheManager.destroy(id);
        }
    }

    public static <X> X get(String id, Class<X> classOf, Callable<X> callable) throws Exception {
        return CacheManager.get(id, classOf, callable, 3600);
    }

    public static <X> X get(String id, Class<X> classOf, Callable<X> callable, int validUntil) throws Exception {
        CacheManager.destroyOld();
        CacheData cacheData = CacheManager.getCacheData();
        if (cacheData.getIds().containsKey(id)) {
            try {
                String uuid = cacheData.getIds().get(id);
                CacheObject object = cacheData.getObjects().get(uuid);
                String content = FileUtils.readFileToString((File)new File(".cache/" + uuid), (Charset)StandardCharsets.UTF_8);
                Object value = object.getType() == CacheTypes.STRING ? content : (object.getType() == CacheTypes.INTEGER ? Integer.valueOf(Integer.parseInt(content)) : (object.getType() == CacheTypes.FLOAT ? Float.valueOf(Float.parseFloat(content)) : (object.getType() == CacheTypes.DOUBLE ? Double.valueOf(Double.parseDouble(content)) : (object.getType() == CacheTypes.LONG ? Long.valueOf(Long.parseLong(content)) : (object.getType() == CacheTypes.BOOLEAN ? Boolean.valueOf(Boolean.parseBoolean(content)) : PBGson.s().fromJson(content, classOf))))));
                return (X)value;
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
                return callable.call();
            }
        }
        X value = callable.call();
        CacheManager.store(id, value, validUntil);
        return value;
    }

    public static synchronized <X> void store(String id, X value) {
        CacheManager.store(id, value, 3600);
    }

    public static synchronized <X> void store(String id, X value, int validUntil) {
        String uuid;
        String v;
        CacheTypes type;
        CacheManager.destroyOld();
        if (value instanceof String) {
            type = CacheTypes.STRING;
            v = (String)value;
        } else if (value instanceof Integer) {
            type = CacheTypes.INTEGER;
            v = Integer.toString((Integer)value);
        } else if (value instanceof Float) {
            type = CacheTypes.FLOAT;
            v = Float.toString(((Float)value).floatValue());
        } else if (value instanceof Double) {
            type = CacheTypes.DOUBLE;
            v = Double.toString((Double)value);
        } else if (value instanceof Long) {
            type = CacheTypes.LONG;
            v = Long.toString((Long)value);
        } else if (value instanceof Boolean) {
            type = CacheTypes.BOOLEAN;
            v = Boolean.toString((Boolean)value);
        } else {
            type = CacheTypes.OBJECT;
            v = PBGson.s().toJson(value);
        }
        CacheObject o = new CacheObject(type, Instant.now().plusSeconds(validUntil));
        CacheData cacheData = CacheManager.getCacheData();
        if (cacheData.getIds().containsKey(id)) {
            uuid = cacheData.getIds().get(id);
            cacheData.delObject(uuid);
        } else {
            do {
                uuid = UUID.randomUUID().toString();
            } while (cacheData.getIds().containsValue(uuid));
            cacheData.addId(id, uuid);
        }
        cacheData.addObject(uuid, o);
        try {
            File file = new File(".cache/" + uuid);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileUtils.writeStringToFile((File)file, (String)v, (Charset)StandardCharsets.UTF_8);
            configHandler.storeConfig(cacheData);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    private static CacheData getCacheData() {
        try {
            if (cacheData != null) {
                return cacheData;
            }
            File folder = new File(".cache");
            if (!folder.exists() || !folder.isDirectory()) {
                folder.mkdirs();
            }
            if (!(configHandler = new ConfigHandler<CacheData>(new CacheData(), ".cache/.cfg")).checkIfExists()) {
                configHandler.saveDefaultConfig();
            }
            cacheData = configHandler.loadConfig();
            return cacheData;
        }
        catch (Exception e) {
            ErrorHandler.handleFatal(e);
            return null;
        }
    }
}

