/*
 * Decompiled with CFR 0.152.
 */
package me.scolastico.mysql.manager.dataholders;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import me.scolastico.mysql.manager.MysqlManager;
import me.scolastico.mysql.manager.dataholders.Fields;
import me.scolastico.mysql.manager.exceptions.NoDataException;
import me.scolastico.mysql.manager.exceptions.NoFieldsException;
import me.scolastico.mysql.manager.exceptions.NotATableException;
import me.scolastico.mysql.manager.exceptions.NotSavedEntryException;
import me.scolastico.mysql.manager.interfaces.Annotations;

@Annotations.Table(tableName="MySQL_Manager_Internal")
public class Database {
    private final MysqlManager mysqlManager;
    @Annotations.TableId
    private Long id = null;
    @Annotations.TableEntry
    private String databaseName = "db";
    @Annotations.TableEntry
    private Fields fields = new Fields();

    public static void generateTable(MysqlManager manager) throws SQLException, NotATableException, NoSuchMethodException, NotSavedEntryException, NoFieldsException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoDataException {
        manager.generateTable(new Database(manager));
    }

    public static Database getById(Long id, MysqlManager mysqlManager) throws SQLException, NotATableException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
        Object obj = mysqlManager.getFromTableById(new Database(mysqlManager), id);
        if (obj != null) {
            return (Database)obj;
        }
        return null;
    }

    public static Database[] searchByDatabaseName(String databaseName, MysqlManager mysqlManager) throws SQLException, NotATableException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objects = mysqlManager.getFromTableBySearch(new Database(mysqlManager), "databaseName", databaseName);
        ArrayList<Database> dataHolders = new ArrayList<Database>();
        for (Object obj : objects) {
            dataHolders.add((Database)obj);
        }
        return dataHolders.toArray(new Database[0]);
    }

    public static Database[] searchByFields(Fields fields, MysqlManager mysqlManager) throws SQLException, NotATableException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objects = mysqlManager.getFromTableBySearch(new Database(mysqlManager), "fields", fields);
        ArrayList<Database> dataHolders = new ArrayList<Database>();
        for (Object obj : objects) {
            dataHolders.add((Database)obj);
        }
        return dataHolders.toArray(new Database[0]);
    }

    public static void deleteTable(MysqlManager manager) throws SQLException, NotATableException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException, InvocationTargetException, NotSavedEntryException {
        manager.deleteTable(new Database(manager));
    }

    public void delete() throws SQLException, NotATableException, NotSavedEntryException {
        if (this.id == null) {
            throw new NotSavedEntryException();
        }
        this.mysqlManager.delete(this, this.id);
    }

    public void update() throws NotSavedEntryException, SQLException, NoSuchFieldException, IllegalAccessException, NoFieldsException, NotATableException, NoSuchMethodException, InvocationTargetException, NoDataException {
        if (this.id == null) {
            throw new NotSavedEntryException();
        }
        this.mysqlManager.updateTable(this);
    }

    public void save() throws SQLException, NotATableException, NoFieldsException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, NoDataException {
        this.id = this.mysqlManager.saveTable(this);
    }

    public Database(MysqlManager mysqlManager) {
        this.mysqlManager = mysqlManager;
    }

    public Database(MysqlManager mysqlManager, String databaseName, Fields fields) {
        this.mysqlManager = mysqlManager;
        this.databaseName = databaseName;
        this.fields = fields;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Fields getFields() {
        return this.fields;
    }

    public void setFields(Fields fields) {
        this.fields = fields;
    }
}

