/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.webs;

import java.io.InputStream;
import me.saro.kit.Texts;
import me.saro.kit.functions.ThrowableConsumer;
import me.saro.kit.functions.ThrowableFunction;
import me.saro.kit.webs.SimpleWebImpl;
import me.saro.kit.webs.SimpleWebResult;

public interface SimpleWeb {
    public static SimpleWeb get(String url) {
        return new SimpleWebImpl(url, "GET");
    }

    public static SimpleWeb post(String url) {
        return new SimpleWebImpl(url, "POST");
    }

    public static SimpleWeb put(String url) {
        return new SimpleWebImpl(url, "PUT");
    }

    public static SimpleWeb patch(String url) {
        return new SimpleWebImpl(url, "PATCH");
    }

    public static SimpleWeb delete(String url) {
        return new SimpleWebImpl(url, "DELETE");
    }

    public String getRequestCharset();

    public String getResponseCharset();

    public static SimpleWeb custom(String url, String method) {
        return new SimpleWebImpl(url, method);
    }

    public SimpleWeb setConnectTimeout(int var1);

    public SimpleWeb setReadTimeout(int var1);

    public SimpleWeb setRequestCharset(String var1);

    public SimpleWeb setResponseCharset(String var1);

    public SimpleWeb setIgnoreCertificate(boolean var1);

    public SimpleWeb addUrlParameter(String var1, String var2);

    public SimpleWeb setHeader(String var1, String var2);

    public SimpleWeb writeBody(byte[] var1);

    public SimpleWeb writeBodyParameter(String var1, String var2);

    public <R> SimpleWebResult<R> toCustom(SimpleWebResult<R> var1, ThrowableFunction<InputStream, R> var2);

    default public <R> SimpleWebResult<R> toCustom(ThrowableFunction<InputStream, R> function) {
        return this.toCustom(new SimpleWebResult(), function);
    }

    default public SimpleWebResult<String> readRawResultStream(ThrowableConsumer<InputStream> reader) {
        return this.toCustom(is -> {
            reader.accept((InputStream)is);
            return "OK";
        });
    }

    default public SimpleWeb setContentType(String value) {
        return this.setHeader("Content-Type", value);
    }

    default public SimpleWeb setContentTypeApplicationJson() {
        return this.setHeader("Content-Type", "application/json");
    }

    default public SimpleWeb writeBody(String text) {
        return this.writeBody(Texts.getBytes(text, this.getRequestCharset()));
    }
}

