/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.hashs;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.saro.kit.Texts;
import me.saro.kit.bytes.Bytes;
import me.saro.kit.hashs.HashAlgorithm;

public class Hashs {
    public static byte[] toHash(HashAlgorithm hashAlgorithm, byte[] data) {
        try {
            return MessageDigest.getInstance(hashAlgorithm.value()).digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toHash(HashAlgorithm hashAlgorithm, String text, String charset) {
        return Hashs.toHash(hashAlgorithm, Texts.getBytes(text, charset));
    }

    public static byte[] toHash(HashAlgorithm hashAlgorithm, String text) {
        return Hashs.toHash(hashAlgorithm, Texts.getBytes(text, "UTF-8"));
    }

    public static String toHashHex(HashAlgorithm hashAlgorithm, String text, String charset) {
        return Bytes.toHex(Hashs.toHash(hashAlgorithm, Texts.getBytes(text, charset)));
    }

    public static String toHashHex(HashAlgorithm hashAlgorithm, String text) {
        return Bytes.toHex(Hashs.toHash(hashAlgorithm, Texts.getBytes(text, "UTF-8")));
    }

    public static String toHashBase64(HashAlgorithm hashAlgorithm, String text, String charset) {
        return Bytes.encodeBase64String(Hashs.toHash(hashAlgorithm, Texts.getBytes(text, charset)));
    }

    public static String toHashBase64(HashAlgorithm hashAlgorithm, String text) {
        return Bytes.encodeBase64String(Hashs.toHash(hashAlgorithm, Texts.getBytes(text, "UTF-8")));
    }
}

