/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.dates;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class Dates {
    private static Map<String, DateTimeFormatter> formatters = new HashMap<String, DateTimeFormatter>();
    private static Map<String, SimpleDateFormat> simpleDateFormats = new HashMap<String, SimpleDateFormat>();

    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        return ZonedDateTime.ofInstant(calendar.toInstant(), tz != null ? tz.toZoneId() : ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        return LocalDateTime.ofInstant(calendar.toInstant(), tz != null ? tz.toZoneId() : ZoneId.systemDefault());
    }

    public static LocalDate toLocalDate(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        return LocalDateTime.ofInstant(calendar.toInstant(), tz != null ? tz.toZoneId() : ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        return LocalDateTime.ofInstant(calendar.toInstant(), tz != null ? tz.toZoneId() : ZoneId.systemDefault()).toLocalTime();
    }

    public static ZonedDateTime parseZonedDateTime(String date, String format, ZoneId zone) {
        return ZonedDateTime.parse(date, Dates.toFormatter(format).withZone(zone));
    }

    public static ZonedDateTime parseZonedDateTime(String date, String format) {
        return ZonedDateTime.parse(date, Dates.toFormatter(format));
    }

    public static LocalDateTime parseLocalDateTime(String date, String format) {
        return LocalDateTime.parse(date, Dates.toFormatter(format));
    }

    public static LocalDate parseLocalDate(String date, String format) {
        return LocalDate.parse(date, Dates.toFormatter(format));
    }

    public static LocalTime parseLocalTime(String date, String format) {
        return LocalTime.parse(date, Dates.toFormatter(format));
    }

    public static Calendar parseCalendar(String date, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Dates.parseDate(date, format));
        return calendar;
    }

    public static Date parseDate(String date, String format) {
        try {
            return Dates.toSimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            throw new DateTimeParseException(e.getMessage(), date, -1, e);
        }
    }

    public static synchronized DateTimeFormatter toFormatter(String format) {
        DateTimeFormatter formatter = formatters.get(format);
        if (formatter == null) {
            formatter = DateTimeFormatter.ofPattern(format);
            formatters.put(format, formatter);
        }
        return formatter;
    }

    public static synchronized SimpleDateFormat toSimpleDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = simpleDateFormats.get(format);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(format);
            simpleDateFormats.put(format, simpleDateFormat);
        }
        return (SimpleDateFormat)simpleDateFormat.clone();
    }

    public static synchronized String format(Date date, String format) {
        return Dates.toSimpleDateFormat(format).format(date);
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(ZonedDateTime zonedDateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(zonedDateTime.getYear(), zonedDateTime.getMonthValue() - 1, zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond());
        calendar.set(14, Math.round(zonedDateTime.getNano() / 1000000));
        calendar.setTimeZone(TimeZone.getTimeZone(zonedDateTime.getZone()));
        return calendar;
    }

    public static Calendar toCalendar(LocalDateTime localDateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(localDateTime.getYear(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
        calendar.set(14, localDateTime.getNano() / 1000000);
        return calendar;
    }

    public static Calendar toCalendar(LocalDate localDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
        return calendar;
    }

    public static Calendar toCalendar(LocalTime localTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(10, localTime.getHour());
        calendar.set(12, localTime.getMinute());
        calendar.set(13, localTime.getSecond());
        calendar.set(14, localTime.getNano() / 1000000);
        return calendar;
    }
}

