/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.dates;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import me.saro.kit.dates.Dates;

public class ConstDateTime {
    private final Calendar calendar = Calendar.getInstance();

    private ConstDateTime(long timeInMillis) {
        this.calendar.setTimeInMillis(timeInMillis);
    }

    public static ConstDateTime now() {
        return new ConstDateTime(Calendar.getInstance().getTimeInMillis());
    }

    public static ConstDateTime parse(long timeInMillis) {
        return new ConstDateTime(timeInMillis);
    }

    public static ConstDateTime parse(String date, String format) {
        return new ConstDateTime(Dates.parseCalendar(date, format).getTimeInMillis());
    }

    public static String format(String date, String oldFormat, String newFormat) {
        try {
            if (date != null && !date.isEmpty()) {
                return ConstDateTime.parse(date, oldFormat).toString(newFormat);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean valid(String date, String format) {
        try {
            if (date != null && format != null) {
                ConstDateTime df = ConstDateTime.parse(date, format);
                return df.toString(format).equals(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public ConstDateTime timezone(TimeZone timeZone) {
        ConstDateTime rv = this.clone();
        rv.calendar.setTimeZone(timeZone);
        return rv;
    }

    public ConstDateTime plusMilliseconds(int milliseconds) {
        ConstDateTime rv = this.clone();
        rv.calendar.add(14, milliseconds);
        return rv;
    }

    public ConstDateTime plusMinutes(int minutes) {
        ConstDateTime rv = this.clone();
        rv.calendar.add(12, minutes);
        return rv;
    }

    public ConstDateTime plusHours(int hours) {
        ConstDateTime rv = this.clone();
        rv.calendar.add(10, hours);
        return rv;
    }

    public ConstDateTime plusDates(int date) {
        ConstDateTime rv = this.clone();
        rv.calendar.add(5, date);
        return rv;
    }

    public ConstDateTime plusMonths(int month) {
        ConstDateTime rv = this.clone();
        rv.calendar.add(2, month);
        return rv;
    }

    public ConstDateTime plusYears(int year) {
        ConstDateTime rv = this.clone();
        rv.calendar.add(1, year);
        return rv;
    }

    public ConstDateTime withTimeInMillis(long timeInMillis) {
        ConstDateTime rv = this.clone();
        rv.calendar.setTimeInMillis(timeInMillis);
        return rv;
    }

    public ConstDateTime withMilliseconds(int milliseconds) {
        ConstDateTime rv = this.clone();
        rv.calendar.set(14, milliseconds);
        return rv;
    }

    public ConstDateTime withSeconds(int seconds) {
        ConstDateTime rv = this.clone();
        rv.calendar.set(13, seconds);
        return rv;
    }

    public ConstDateTime withMinutes(int minutes) {
        ConstDateTime rv = this.clone();
        rv.calendar.set(12, minutes);
        return rv;
    }

    public ConstDateTime withHours(int hours) {
        ConstDateTime rv = this.clone();
        rv.calendar.set(10, hours);
        return rv;
    }

    public ConstDateTime withDayOfMonth(int day) {
        ConstDateTime rv = this.clone();
        rv.calendar.set(5, day);
        return rv;
    }

    public ConstDateTime withMonth(int month) {
        ConstDateTime rv = this.clone();
        rv.calendar.set(2, month);
        return rv;
    }

    public ConstDateTime withYear(int year) {
        ConstDateTime rv = this.clone();
        rv.calendar.set(1, year);
        return rv;
    }

    public long getTimeInMillis() {
        return this.calendar.getTimeInMillis();
    }

    public int getMilliseconds() {
        return this.calendar.get(14);
    }

    public int getSeconds() {
        return this.calendar.get(13);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getHours() {
        return this.calendar.get(10);
    }

    public int getDate() {
        return this.calendar.get(5);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public int getDayOfIntWeek() {
        switch (this.calendar.get(7)) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        throw new RuntimeException();
    }

    public int getWeekOfMonth() {
        return this.calendar.get(4);
    }

    public int getWeekOfYear() {
        return this.calendar.get(3);
    }

    public int getLastDayOfMonth() {
        return this.calendar.getActualMaximum(5);
    }

    public int diffYears(ConstDateTime constDateTime) {
        return Math.abs(this.getYear() - constDateTime.getYear());
    }

    public int diffMonths(ConstDateTime constDateTime) {
        return Math.abs(this.getYear() * 12 + this.getMonth() - (constDateTime.getYear() * 12 + constDateTime.getMonth()));
    }

    public int diffDays(ConstDateTime constDateTime) {
        Calendar sd = this.onlyDate().calendar;
        Calendar ed = constDateTime.onlyDate().calendar;
        int diffDays = (int)((ed.getTimeInMillis() - sd.getTimeInMillis()) / 86400000L);
        sd.add(5, diffDays);
        while (sd.before(ed)) {
            sd.add(5, 1);
            ++diffDays;
        }
        while (sd.after(ed)) {
            sd.add(5, -1);
            --diffDays;
        }
        return Math.abs(diffDays);
    }

    public int remainDaysUntilLastDayOfMonth() {
        return this.diffDays(this.withDayOfMonth(this.getLastDayOfMonth()));
    }

    public String format(String format) {
        return Dates.format(this.calendar.getTime(), format);
    }

    public String toString(String format) {
        return this.format(format);
    }

    public String toString() {
        return this.toISO8601();
    }

    public String toISO8601() {
        String format = this.format("yyyy-MM-dd'T'HH:mm:ssZ");
        return format.lastIndexOf(43) != format.length() - 5 ? format.replaceFirst("([\\d]{2})$", ":$1") : format;
    }

    public ConstDateTime onlyDate() {
        ConstDateTime rv = this.clone();
        Calendar cal = rv.calendar;
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return rv;
    }

    public boolean equalsYear(ConstDateTime constDateTime) {
        return this.getYear() == constDateTime.getYear();
    }

    public boolean equalsYearMonth(ConstDateTime constDateTime) {
        return this.equalsYear(constDateTime) && this.getMonth() == constDateTime.getMonth();
    }

    public boolean equalsYearMonthDate(ConstDateTime constDateTime) {
        return this.equalsYearMonth(constDateTime) && this.getDate() == constDateTime.getDate();
    }

    public Date toDate() {
        return this.calendar.getTime();
    }

    public ConstDateTime clone() {
        return new ConstDateTime(((Calendar)this.calendar.clone()).getTimeInMillis());
    }

    public Calendar toCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().getName().equals(obj.getClass().getName())) {
            return this.getTimeInMillis() == ((ConstDateTime)obj).getTimeInMillis();
        }
        return false;
    }
}

