/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.crypts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import me.saro.kit.Streams;
import me.saro.kit.crypts.SimpleCrypt;

class SimpleCryptImpl
implements SimpleCrypt {
    private final Integer LOCK = 1;
    private final Cipher cipher;

    SimpleCryptImpl(Cipher cipher) {
        this.cipher = cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void to(InputStream is, OutputStream os) throws IOException {
        Integer n = this.LOCK;
        synchronized (n) {
            try (CipherOutputStream cos = new CipherOutputStream(os, this.cipher);){
                Streams.link(is, cos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void to(File in, File out, boolean overwrite) throws IOException {
        Integer n = this.LOCK;
        synchronized (n) {
            if (!in.exists()) {
                throw new IOException(in.getAbsolutePath() + " does not exist");
            }
            if (out.exists()) {
                if (overwrite) {
                    out.delete();
                } else {
                    throw new IOException(in.getAbsolutePath() + " is already exist");
                }
            }
            out.getParentFile().mkdirs();
            try (FileInputStream fis = new FileInputStream(in);
                 FileOutputStream fos = new FileOutputStream(out);
                 CipherOutputStream cos = new CipherOutputStream(fos, this.cipher);){
                Streams.link(fis, cos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes(byte[] data, int offset, int length) throws IllegalBlockSizeException, BadPaddingException {
        byte[] rv;
        Integer n = this.LOCK;
        synchronized (n) {
            rv = this.cipher.doFinal(data, offset, length);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes(byte[] data) throws IllegalBlockSizeException, BadPaddingException {
        byte[] rv;
        Integer n = this.LOCK;
        synchronized (n) {
            rv = this.cipher.doFinal(data);
        }
        return rv;
    }
}

